/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util;

import com.datastax.oss.driver.api.mapper.annotations.HierarchyScanStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.util.Classes;
import com.datastax.oss.driver.internal.mapper.processor.util.HierarchyScanner;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class HierarchyScannerTest {
    private final ProcessorContext context = (ProcessorContext)Mockito.mock(ProcessorContext.class);

    public HierarchyScannerTest() {
        Types types = (Types)Mockito.mock(Types.class);
        Classes classUtils = (Classes)Mockito.mock(Classes.class);
        Elements elements = (Elements)Mockito.mock(Elements.class);
        Mockito.when((Object)elements.getTypeElement(Mockito.anyString())).thenReturn((Object)((TypeElement)Mockito.mock(TypeElement.class)));
        Mockito.when((Object)this.context.getTypeUtils()).thenReturn((Object)types);
        Mockito.when((Object)this.context.getClassUtils()).thenReturn((Object)classUtils);
        Mockito.when((Object)this.context.getElementUtils()).thenReturn((Object)elements);
        Mockito.when((Object)classUtils.isSame((Element)Mockito.any(Element.class), (Class)Mockito.any(Class.class))).thenReturn((Object)false);
        Mockito.when((Object)types.isSameType((TypeMirror)Mockito.any(TypeMirror.class), (TypeMirror)Mockito.any(TypeMirror.class))).thenAnswer(invocation -> invocation.getArgument(0) == invocation.getArgument(1));
    }

    @Test
    public void should_build_proper_hierarchy_with_default_strategy() {
        MockInterface a = this.i("a", new MockInterface[0]);
        MockInterface z = this.i("z", a);
        MockInterface y = this.i("y", z);
        MockInterface x = this.i("x", y);
        MockInterface w = this.i("w", new MockInterface[0]);
        MockClass b = this.c("b", null, a);
        MockClass c = this.c("c", b, x, w);
        Assertions.assertThat((String)HierarchyScanner.resolveTypeHierarchy((TypeElement)c.classElement, (ProcessorContext)this.context).toString()).isEqualTo("[c, b, x, w, a, y, z]");
    }

    @Test
    public void should_not_scan_hierarchy_if_scanAncestors_is_false() {
        HierarchyScanStrategy strategy = (HierarchyScanStrategy)Mockito.mock(HierarchyScanStrategy.class);
        Mockito.when((Object)strategy.scanAncestors()).thenReturn((Object)false);
        MockInterface a = this.i("a", new MockInterface[0]);
        MockInterface z = this.i("z", a);
        MockInterface y = this.i("y", strategy, null, z);
        MockInterface x = this.i("x", y);
        MockInterface w = this.i("w", new MockInterface[0]);
        MockClass b = this.c("b", null, a);
        MockClass c = this.c("c", b, x, w);
        Assertions.assertThat((String)HierarchyScanner.resolveTypeHierarchy((TypeElement)c.classElement, (ProcessorContext)this.context).toString()).isEqualTo("[c]");
    }

    @Test
    public void should_build_property_hierarchy_with_strategy_defined_on_class() {
        HierarchyScanStrategy bHighest = (HierarchyScanStrategy)Mockito.mock(HierarchyScanStrategy.class);
        Mockito.when((Object)bHighest.highestAncestor()).thenReturn(this.getClass());
        Mockito.when((Object)bHighest.includeHighestAncestor()).thenReturn((Object)false);
        Mockito.when((Object)bHighest.scanAncestors()).thenReturn((Object)true);
        MockInterface a = this.i("a", new MockInterface[0]);
        MockInterface r = this.i("r", new MockInterface[0]);
        MockInterface z = this.i("z", a);
        MockInterface y = this.i("y", z);
        MockInterface x = this.i("x", y);
        MockInterface w = this.i("w", new MockInterface[0]);
        MockClass b = this.c("b", null, a, r);
        Mockito.when((Object)this.context.getClassUtils().isSame((Element)b.classElement, this.getClass())).thenReturn((Object)true);
        MockClass d = this.c("d", bHighest, b, b, new MockInterface[0]);
        MockClass c = this.c("c", d, x, w);
        Assertions.assertThat((String)HierarchyScanner.resolveTypeHierarchy((TypeElement)c.classElement, (ProcessorContext)this.context).toString()).isEqualTo("[c, d, x, w, y, z, a]");
    }

    private MockClass c(String name, MockClass parent, MockInterface ... interfaces) {
        return new MockClass(name, null, null, parent, interfaces);
    }

    @Test
    public void should_build_property_hierarchy_with_strategy_defined_on_interface_include_highest() {
        HierarchyScanStrategy yHighest = (HierarchyScanStrategy)Mockito.mock(HierarchyScanStrategy.class);
        Mockito.when((Object)yHighest.includeHighestAncestor()).thenReturn((Object)true);
        Mockito.when((Object)yHighest.scanAncestors()).thenReturn((Object)true);
        MockInterface a = this.i("a", new MockInterface[0]);
        MockInterface r = this.i("r", new MockInterface[0]);
        MockInterface z = this.i("z", a);
        MockInterface y = this.i("y", z);
        MockInterface x = this.i("x", yHighest, (MockElement)y, y);
        Mockito.when((Object)this.context.getClassUtils().isSame((Element)y.classElement, this.getClass())).thenReturn((Object)true);
        MockInterface w = this.i("w", new MockInterface[0]);
        MockClass b = this.c("b", null, a, r);
        MockClass d = this.c("d", b, new MockInterface[0]);
        MockClass c = this.c("c", d, x, w);
        Assertions.assertThat((String)HierarchyScanner.resolveTypeHierarchy((TypeElement)c.classElement, (ProcessorContext)this.context).toString()).isEqualTo("[c, d, x, w, b, y, a, r]");
    }

    private MockClass c(String name, HierarchyScanStrategy strategy, MockElement highestAncestor, MockClass parent, MockInterface ... interfaces) {
        return new MockClass(name, strategy, highestAncestor, parent, interfaces);
    }

    private MockInterface i(String name, MockInterface ... interfaces) {
        return new MockInterface(name, null, null, interfaces);
    }

    private MockInterface i(String name, HierarchyScanStrategy strategy, MockElement highestAncestor, MockInterface ... interfaces) {
        return new MockInterface(name, strategy, highestAncestor, interfaces);
    }

    private TypeMirror root() {
        TypeMirror noneMirror = (TypeMirror)Mockito.mock(TypeMirror.class);
        Mockito.when((Object)((Object)noneMirror.getKind())).thenReturn((Object)TypeKind.NONE);
        return noneMirror;
    }

    class MockInterface
    extends MockElement {
        MockInterface(String name, HierarchyScanStrategy strategy, MockElement highestAncestor, MockInterface ... interfaces) {
            super(name, strategy, highestAncestor, null, interfaces);
        }
    }

    class MockClass
    extends MockElement {
        MockClass(String name, HierarchyScanStrategy strategy, MockElement highestAncestor, MockClass parent, MockInterface ... interfaces) {
            super(name, strategy, highestAncestor, parent, interfaces);
        }
    }

    class MockElement {
        final String name;
        final TypeMirror mirror;
        final TypeElement classElement;
        final List<MockElement> interfaces;
        final MockClass parent;
        final Name qfName;

        MockElement(String name, HierarchyScanStrategy strategy, MockElement highestAncestor, MockClass parent, MockInterface ... interfaces) {
            this.name = name;
            this.parent = parent;
            this.interfaces = Arrays.asList(interfaces);
            this.classElement = (TypeElement)Mockito.mock(TypeElement.class);
            Mockito.when((Object)this.classElement.toString()).thenReturn((Object)name);
            TypeMirror parentMirror = parent != null ? parent.mirror : HierarchyScannerTest.this.root();
            Mockito.when((Object)this.classElement.getSuperclass()).thenReturn((Object)parentMirror);
            ArrayList interfaceList = Lists.newArrayList();
            for (MockInterface i : interfaces) {
                interfaceList.add(i.mirror);
            }
            Mockito.when(this.classElement.getInterfaces()).thenReturn((Object)interfaceList);
            this.mirror = (TypeMirror)Mockito.mock(TypeMirror.class);
            Mockito.when((Object)((Object)this.mirror.getKind())).thenReturn((Object)TypeKind.DECLARED);
            Mockito.when((Object)this.mirror.toString()).thenReturn((Object)name);
            Mockito.when((Object)this.classElement.asType()).thenReturn((Object)this.mirror);
            Mockito.when((Object)HierarchyScannerTest.this.context.getTypeUtils().asElement(this.mirror)).thenReturn((Object)this.classElement);
            this.qfName = (Name)Mockito.mock(Name.class);
            Mockito.when((Object)this.qfName.toString()).thenReturn((Object)name);
            Mockito.when((Object)this.classElement.getQualifiedName()).thenReturn((Object)this.qfName);
            if (strategy != null) {
                Mockito.when((Object)this.classElement.getAnnotation(HierarchyScanStrategy.class)).thenReturn((Object)strategy);
                AnnotationMirror annotationMirror = (AnnotationMirror)Mockito.mock(AnnotationMirror.class);
                DeclaredType annotationType = (DeclaredType)Mockito.mock(DeclaredType.class);
                Mockito.when((Object)annotationMirror.getAnnotationType()).thenReturn((Object)annotationType);
                ArrayList annotationMirrors = Lists.newArrayList((Object[])new AnnotationMirror[]{annotationMirror});
                Mockito.when(this.classElement.getAnnotationMirrors()).thenReturn((Object)annotationMirrors);
                Mockito.when((Object)HierarchyScannerTest.this.context.getClassUtils().isSame((TypeMirror)annotationType, HierarchyScanStrategy.class)).thenReturn((Object)true);
                HashMap annotationElementValues = Maps.newHashMap();
                annotationElementValues.put(this.mockAnnotationElement("scanAncestors"), this.mockAnnotationValue(strategy.scanAncestors()));
                annotationElementValues.put(this.mockAnnotationElement("includeHighestAncestor"), this.mockAnnotationValue(strategy.includeHighestAncestor()));
                if (highestAncestor != null) {
                    annotationElementValues.put(this.mockAnnotationElement("highestAncestor"), this.mockAnnotationValue(highestAncestor.mirror));
                }
                Mockito.when(annotationMirror.getElementValues()).thenReturn((Object)annotationElementValues);
            }
        }

        private ExecutableElement mockAnnotationElement(String key) {
            ExecutableElement element = (ExecutableElement)Mockito.mock(ExecutableElement.class);
            Name name = (Name)Mockito.mock(Name.class);
            Mockito.when((Object)name.contentEquals(key)).thenReturn((Object)true);
            Mockito.when((Object)element.getSimpleName()).thenReturn((Object)name);
            return element;
        }

        private AnnotationValue mockAnnotationValue(Object value) {
            AnnotationValue aValue = (AnnotationValue)Mockito.mock(AnnotationValue.class);
            Mockito.when((Object)aValue.getValue()).thenReturn(value);
            return aValue;
        }
    }
}

