/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.DaoFactory;
import com.datastax.oss.driver.api.mapper.annotations.DaoKeyspace;
import com.datastax.oss.driver.api.mapper.annotations.DaoTable;
import com.datastax.oss.driver.internal.mapper.DaoCacheKey;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.mapper.MapperImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class MapperDaoFactoryMethodGenerator
implements MethodGenerator {
    private final ExecutableElement methodElement;
    private final TypeElement processedType;
    private final MapperImplementationSharedCode enclosingClass;
    private final ProcessorContext context;

    public MapperDaoFactoryMethodGenerator(ExecutableElement methodElement, TypeElement processedType, MapperImplementationSharedCode enclosingClass, ProcessorContext context) {
        this.methodElement = methodElement;
        this.processedType = processedType;
        this.enclosingClass = enclosingClass;
        this.context = context;
    }

    @Override
    public Optional<MethodSpec> generate() {
        ClassName daoImplementationName = null;
        boolean isAsync = false;
        TypeMirror returnTypeMirror = this.methodElement.getReturnType();
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            Object typeArgumentElement;
            TypeMirror typeArgument;
            DeclaredType declaredReturnType = (DeclaredType)returnTypeMirror;
            if (declaredReturnType.getTypeArguments().isEmpty()) {
                Element returnTypeElement = declaredReturnType.asElement();
                if (returnTypeElement.getAnnotation(Dao.class) != null) {
                    daoImplementationName = GeneratedNames.daoImplementation((TypeElement)returnTypeElement);
                }
            } else if (this.context.getClassUtils().isFuture(declaredReturnType) && (typeArgument = declaredReturnType.getTypeArguments().get(0)).getKind() == TypeKind.DECLARED && (typeArgumentElement = ((DeclaredType)typeArgument).asElement()).getAnnotation(Dao.class) != null) {
                daoImplementationName = GeneratedNames.daoImplementation((TypeElement)typeArgumentElement);
                isAsync = true;
            }
        }
        if (daoImplementationName == null) {
            this.context.getMessager().error(this.methodElement, this.processedType, "Invalid return type: %s methods must return a %s-annotated interface, or future thereof", DaoFactory.class.getSimpleName(), Dao.class.getSimpleName());
            return Optional.empty();
        }
        String keyspaceArgumentName = null;
        String tableArgumentName = null;
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            if (variableElement.getAnnotation(DaoKeyspace.class) != null) {
                if ((keyspaceArgumentName = this.validateKeyspaceOrTableParameter(variableElement, keyspaceArgumentName, DaoKeyspace.class, this.context)) != null) continue;
                return Optional.empty();
            }
            if (variableElement.getAnnotation(DaoTable.class) != null) {
                if ((tableArgumentName = this.validateKeyspaceOrTableParameter(variableElement, tableArgumentName, DaoTable.class, this.context)) != null) continue;
                return Optional.empty();
            }
            this.context.getMessager().error(this.methodElement, this.processedType, "Invalid parameter annotations: %s method parameters must be annotated with @%s or @%s", DaoFactory.class.getSimpleName(), DaoKeyspace.class.getSimpleName(), DaoTable.class.getSimpleName());
            return Optional.empty();
        }
        boolean isCachedByKeyspaceAndTable = keyspaceArgumentName != null || tableArgumentName != null;
        TypeName typeName = ClassName.get((TypeMirror)this.methodElement.getReturnType());
        String suggestedFieldName = this.methodElement.getSimpleName() + "Cache";
        String fieldName = isCachedByKeyspaceAndTable ? this.enclosingClass.addDaoMapField(suggestedFieldName, typeName) : this.enclosingClass.addDaoSimpleField(suggestedFieldName, typeName, (TypeName)daoImplementationName, isAsync);
        MethodSpec.Builder overridingMethodBuilder = GeneratedCodePatterns.override(this.methodElement);
        if (isCachedByKeyspaceAndTable) {
            overridingMethodBuilder.addCode("$1T key = new $1T(", new Object[]{DaoCacheKey.class});
            if (keyspaceArgumentName == null) {
                overridingMethodBuilder.addCode("($T)null", new Object[]{CqlIdentifier.class});
            } else {
                overridingMethodBuilder.addCode("$L", new Object[]{keyspaceArgumentName});
            }
            overridingMethodBuilder.addCode(", ", new Object[0]);
            if (tableArgumentName == null) {
                overridingMethodBuilder.addCode("($T)null", new Object[]{CqlIdentifier.class});
            } else {
                overridingMethodBuilder.addCode("$L", new Object[]{tableArgumentName});
            }
            overridingMethodBuilder.addCode(");\n", new Object[0]).addStatement("return $L.computeIfAbsent(key, k -> $T.$L(context.withKeyspaceAndTable(k.getKeyspaceId(), k.getTableId())))", new Object[]{fieldName, daoImplementationName, isAsync ? "initAsync" : "init"});
        } else {
            overridingMethodBuilder.addStatement("return $L.get()", new Object[]{fieldName});
        }
        return Optional.of(overridingMethodBuilder.build());
    }

    private String validateKeyspaceOrTableParameter(VariableElement candidate, String previous, Class<?> annotation, ProcessorContext context) {
        if (previous != null) {
            context.getMessager().error(candidate, this.processedType, "Invalid parameter annotations: only one %s method parameter can be annotated with @%s", DaoFactory.class.getSimpleName(), annotation.getSimpleName());
            return null;
        }
        TypeMirror type = candidate.asType();
        if (!context.getClassUtils().isSame(type, String.class) && !context.getClassUtils().isSame(type, CqlIdentifier.class)) {
            context.getMessager().error(candidate, this.processedType, "Invalid parameter type: @%s-annotated parameter of %s methods must be of type %s or %s", annotation.getSimpleName(), DaoFactory.class.getSimpleName(), String.class.getSimpleName(), CqlIdentifier.class.getSimpleName());
            return null;
        }
        return candidate.getSimpleName().toString();
    }
}

