/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.mapper.processor.entity.BuiltInNameConversions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BuiltInNameConversionsTest {
    @Test
    public void should_convert_to_cql() {
        this.should_convert_to_cql("Product", NamingConvention.CASE_INSENSITIVE, "Product");
        this.should_convert_to_cql("productId", NamingConvention.CASE_INSENSITIVE, "productId");
        this.should_convert_to_cql("Product", NamingConvention.EXACT_CASE, "\"Product\"");
        this.should_convert_to_cql("productId", NamingConvention.EXACT_CASE, "\"productId\"");
        this.should_convert_to_cql("Product", NamingConvention.LOWER_CAMEL_CASE, "\"product\"");
        this.should_convert_to_cql("productId", NamingConvention.LOWER_CAMEL_CASE, "\"productId\"");
        this.should_convert_to_cql("Product", NamingConvention.UPPER_CAMEL_CASE, "\"Product\"");
        this.should_convert_to_cql("productId", NamingConvention.UPPER_CAMEL_CASE, "\"ProductId\"");
        this.should_convert_to_cql("Product", NamingConvention.SNAKE_CASE_INSENSITIVE, "product");
        this.should_convert_to_cql("productId", NamingConvention.SNAKE_CASE_INSENSITIVE, "product_id");
        this.should_convert_to_cql("Product", NamingConvention.UPPER_SNAKE_CASE, "\"PRODUCT\"");
        this.should_convert_to_cql("productId", NamingConvention.UPPER_SNAKE_CASE, "\"PRODUCT_ID\"");
        this.should_convert_to_cql("Product", NamingConvention.UPPER_CASE, "\"PRODUCT\"");
        this.should_convert_to_cql("productId", NamingConvention.UPPER_CASE, "\"PRODUCTID\"");
    }

    private void should_convert_to_cql(String javaName, NamingConvention convention, String expectedCqlName) {
        String actualCqlName = BuiltInNameConversions.toCassandraName((String)javaName, (NamingConvention)convention);
        Assertions.assertThat((String)actualCqlName).isEqualTo(expectedCqlName);
    }
}

