/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.NamingStrategy;
import com.datastax.oss.driver.api.mapper.entity.naming.NameConverter;
import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.mapper.processor.MapperProcessorTest;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.junit.Test;

public class EntityNamingStrategyTest
extends MapperProcessorTest {
    private static final ClassName CUSTOM_CONVERTER_CLASS_NAME = ClassName.get((String)"test", (String)"CustomConverter", (String[])new String[0]);
    private static final TypeSpec CUSTOM_CONVERTER_CLASS = TypeSpec.classBuilder((ClassName)CUSTOM_CONVERTER_CLASS_NAME).addSuperinterface(NameConverter.class).addMethod(MethodSpec.methodBuilder((String)"toCassandraName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addParameter(String.class, "javaName", new Modifier[0]).addStatement("return null;", new Object[0]).build()).build();

    private TypeSpec.Builder entityTemplate() {
        return TypeSpec.classBuilder((String)"TestEntity").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Entity.class).addField(TypeName.INT, "i", new Modifier[]{Modifier.PRIVATE}).addMethod(MethodSpec.methodBuilder((String)"setI").addParameter(TypeName.INT, "i", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build()).addMethod(MethodSpec.methodBuilder((String)"getI").returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return 0", new Object[0]).build());
    }

    @Test
    public void should_fail_if_both_convention_and_converter_specified() {
        this.should_fail_with_expected_error("Invalid annotation configuration: NamingStrategy must have either a 'convention' or 'customConverterClass' argument, but not both", "test", CUSTOM_CONVERTER_CLASS, this.entityTemplate().addAnnotation(AnnotationSpec.builder(NamingStrategy.class).addMember("convention", "$T.CASE_INSENSITIVE", new Object[]{NamingConvention.class}).addMember("customConverterClass", "$T.class", new Object[]{CUSTOM_CONVERTER_CLASS_NAME}).build()).build());
    }

    @Test
    public void should_fail_if_neither_convention_nor_converter_specified() {
        this.should_fail_with_expected_error("Invalid annotation configuration: NamingStrategy must have either a 'convention' or 'customConverterClass' argument", "test", CUSTOM_CONVERTER_CLASS, this.entityTemplate().addAnnotation(NamingStrategy.class).build());
    }

    @Test
    public void should_warn_if_multiple_conventions_specified() {
        this.should_succeed_with_expected_warning("Too many naming conventions: NamingStrategy must have at most one 'convention' argument (will use the first one: CASE_INSENSITIVE)", "test", CUSTOM_CONVERTER_CLASS, this.entityTemplate().addAnnotation(AnnotationSpec.builder(NamingStrategy.class).addMember("convention", "{ $1T.CASE_INSENSITIVE, $1T.EXACT_CASE }", new Object[]{NamingConvention.class}).build()).build());
    }

    @Test
    public void should_warn_if_multiple_converters_specified() {
        this.should_succeed_with_expected_warning("Too many custom converters: NamingStrategy must have at most one 'customConverterClass' argument (will use the first one: test.CustomConverter)", "test", CUSTOM_CONVERTER_CLASS, this.entityTemplate().addAnnotation(AnnotationSpec.builder(NamingStrategy.class).addMember("customConverterClass", "{ $1T.class, $1T.class }", new Object[]{CUSTOM_CONVERTER_CLASS_NAME}).build()).build());
    }
}

