/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.datastax.oss.driver.internal.mapper.processor.MapperProcessor;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.google.testing.compile.Compiler;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileObject;

public abstract class MapperProcessorTest {
    protected Compilation compileWithMapperProcessor(String packageName, Iterable<?> options, TypeSpec ... typeSpecs) {
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        for (TypeSpec typeSpec : typeSpecs) {
            files.add(JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build().toJavaFileObject());
        }
        return Compiler.javac().withProcessors(new Processor[]{this.getMapperProcessor()}).withOptions(options).compile(files);
    }

    @NonNull
    protected MapperProcessor getMapperProcessor() {
        return new MapperProcessor();
    }

    protected Compilation compileWithMapperProcessor(String packageName, TypeSpec ... typeSpecs) {
        return this.compileWithMapperProcessor(packageName, Collections.emptyList(), typeSpecs);
    }

    protected void should_fail_with_expected_error(String expectedError, String packageName, TypeSpec ... typeSpecs) {
        Compilation compilation = this.compileWithMapperProcessor(packageName, typeSpecs);
        CompilationSubject.assertThat((Compilation)compilation).hadErrorContaining(expectedError);
    }

    protected void should_succeed_with_expected_warning(String expectedWarning, String packageName, TypeSpec ... typeSpecs) {
        Compilation compilation = this.compileWithMapperProcessor(packageName, typeSpecs);
        CompilationSubject.assertThat((Compilation)compilation).hadWarningContaining(expectedWarning);
    }

    protected void should_succeed_without_warnings(String packageName, TypeSpec ... typeSpecs) {
        Compilation compilation = this.compileWithMapperProcessor(packageName, Collections.emptyList(), typeSpecs);
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
    }
}

