/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGeneratorTest;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collections;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DaoImplementationGeneratorTest
extends DaoMethodGeneratorTest {
    @Test
    public void should_fail_if_method_is_not_annotated() {
        this.should_fail_with_expected_error("Unrecognized method signature: no implementation will be generated", MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(Row.class, (String)"source", (Modifier[])new Modifier[0]).build()).returns((TypeName)ENTITY_CLASS_NAME).build());
    }

    @Test
    public void should_ignore_static_methods() {
        this.should_succeed_without_warnings(MethodSpec.methodBuilder((String)"doNothing").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build());
    }

    @Test
    public void should_ignore_default_methods() {
        this.should_succeed_without_warnings(MethodSpec.methodBuilder((String)"doNothing").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).build());
    }

    @Test
    public void should_compile_with_logging_enabled() {
        Compilation compilation = this.compileWithMapperProcessor("test", Collections.emptyList(), ENTITY_SPEC, TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(MethodSpec.methodBuilder((String)"update").addAnnotation(Update.class).addParameter((TypeName)ENTITY_CLASS_NAME, "product", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build()).build());
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        this.assertGeneratedFileContains(compilation, "private static final Logger LOG = LoggerFactory.getLogger(ProductDaoImpl__MapperGenerated.class);");
        this.assertGeneratedFileContains(compilation, "LOG.debug(\"[{}] Initializing new instance");
        this.assertGeneratedFileContains(compilation, "LOG.debug(\"[{}] Preparing query `{}` for method");
    }

    @Test
    @UseDataProvider(value="disabledLoggingOptions")
    public void should_compile_with_logging_disabled(Iterable<?> options) {
        Compilation compilation = this.compileWithMapperProcessor("test", options, ENTITY_SPEC, TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(MethodSpec.methodBuilder((String)"update").addAnnotation(Update.class).addParameter((TypeName)ENTITY_CLASS_NAME, "product", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build()).build());
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        this.assertGeneratedFileDoesNotContain(compilation, "LoggerFactory.getLogger");
        this.assertGeneratedFileDoesNotContain(compilation, "LOG.debug");
    }

    protected void assertGeneratedFileDoesNotContain(Compilation compilation, String string) {
        CompilationSubject.assertThat((Compilation)compilation).generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "test", "ProductDaoImpl__MapperGenerated.java").contentsAsUtf8String().doesNotContain((CharSequence)string);
    }

    protected void assertGeneratedFileContains(Compilation compilation, String string) {
        CompilationSubject.assertThat((Compilation)compilation).generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "test", "ProductDaoImpl__MapperGenerated.java").contentsAsUtf8String().contains((CharSequence)string);
    }

    @DataProvider
    public static Object[][] disabledLoggingOptions() {
        return new Object[][]{{Collections.singletonList("-Acom.datastax.oss.driver.mapper.logs.enabled=false")}, {Collections.singletonList("-Acom.datastax.oss.driver.mapper.logs.enabled=malformed")}};
    }
}

