/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGeneratorTest;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoUpdateMethodGenerator;
import com.google.common.truth.Truth;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import javax.lang.model.element.Modifier;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class DaoUpdateMethodGeneratorTest
extends DaoMethodGeneratorTest {
    private static final AnnotationSpec UPDATE_ANNOTATION = AnnotationSpec.builder(Update.class).build();

    @Override
    @Test
    @UseDataProvider(value="invalidSignatures")
    public void should_fail_with_expected_error(String expectedError, MethodSpec method) {
        super.should_fail_with_expected_error(expectedError, method);
    }

    @DataProvider
    public static Object[][] invalidSignatures() {
        return new Object[][]{{"Update methods must take the entity to update as the first parameter", MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(UPDATE_ANNOTATION).build()}, {"Update methods must take the entity to update as the first parameter", MethodSpec.methodBuilder((String)"update").addAnnotation(UPDATE_ANNOTATION).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"a", (Modifier[])new Modifier[0]).build()).build()}, {"Invalid return type: Update methods must return one of [VOID, FUTURE_OF_VOID, RESULT_SET, FUTURE_OF_ASYNC_RESULT_SET, BOOLEAN, FUTURE_OF_BOOLEAN]", MethodSpec.methodBuilder((String)"update").addAnnotation(UPDATE_ANNOTATION).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).returns(TypeName.INT).build()}, {"Invalid annotation parameters: Update cannot have both ifExists and customIfClause", MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(Update.class).addMember("ifExists", "true", new Object[0]).addMember("customIfClause", "$S", new Object[]{"1 = 1"}).build()).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).returns(TypeName.VOID).build()}};
    }

    @Test
    public void should_warn_when_non_bind_marker_has_cql_name() {
        this.should_succeed_with_expected_warning("Parameter entity does not refer to a bind marker, @CqlName annotation will be ignored", MethodSpec.methodBuilder((String)"update").addAnnotation(AnnotationSpec.builder(Update.class).addMember("customIfClause", "$S", new Object[]{"description LIKE :searchString"}).build()).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(CqlName.class).addMember("value", "$S", new Object[]{"irrelevant"}).build()).build()).addParameter(ParameterSpec.builder(String.class, (String)"searchString", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(CqlName.class).addMember("value", "$S", new Object[]{"irrelevant"}).build()).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
    }

    @Test
    @UseDataProvider(value="usingTimestampProvider")
    public void should_process_timestamp(String timestamp, CodeBlock expected) {
        ProcessorContext processorContext = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        DaoUpdateMethodGenerator daoUpdateMethodGenerator = new DaoUpdateMethodGenerator(null, null, null, null, processorContext);
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        daoUpdateMethodGenerator.maybeAddTimestamp(timestamp, builder);
        Truth.assertThat((Object)builder.build().code).isEqualTo((Object)expected);
    }

    @Test
    @UseDataProvider(value="usingTtlProvider")
    public void should_process_ttl(String ttl, CodeBlock expected) {
        ProcessorContext processorContext = (ProcessorContext)Mockito.mock(ProcessorContext.class);
        DaoUpdateMethodGenerator daoUpdateMethodGenerator = new DaoUpdateMethodGenerator(null, null, null, null, processorContext);
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        daoUpdateMethodGenerator.maybeAddTtl(ttl, builder);
        Truth.assertThat((Object)builder.build().code).isEqualTo((Object)expected);
    }

    @DataProvider
    public static Object[][] usingTimestampProvider() {
        return new Object[][]{{"1", CodeBlock.of((String)".usingTimestamp(1)", (Object[])new Object[0])}, {":ts", CodeBlock.of((String)".usingTimestamp($T.bindMarker($S))", (Object[])new Object[]{QueryBuilder.class, "ts"})}, {"1", CodeBlock.of((String)".usingTimestamp(1)", (Object[])new Object[0])}, {":TS", CodeBlock.of((String)".usingTimestamp($T.bindMarker($S))", (Object[])new Object[]{QueryBuilder.class, "TS"})}};
    }

    @DataProvider
    public static Object[][] usingTtlProvider() {
        return new Object[][]{{"1", CodeBlock.of((String)".usingTtl(1)", (Object[])new Object[0])}, {":ttl", CodeBlock.of((String)".usingTtl($T.bindMarker($S))", (Object[])new Object[]{QueryBuilder.class, "ttl"})}, {"1", CodeBlock.of((String)".usingTtl(1)", (Object[])new Object[0])}, {":TTL", CodeBlock.of((String)".usingTtl($T.bindMarker($S))", (Object[])new Object[]{QueryBuilder.class, "TTL"})}};
    }
}

