/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.internal.mapper.processor.MapperProcessorTest;
import com.google.common.truth.StringSubject;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.junit.Test;

public class EntityAnnotationTest
extends MapperProcessorTest {
    @Test
    public void should_work_on_nested_class() {
        Compilation compilation = this.compileWithMapperProcessor("test", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Foo", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addType(TypeSpec.classBuilder((String)"Bar").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Entity.class).addMethod(MethodSpec.methodBuilder((String)"setI").addParameter(TypeName.INT, "i", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build()).addMethod(MethodSpec.methodBuilder((String)"getI").returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return 0", new Object[0]).build()).build()).build());
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        CompilationSubject.assertThat((Compilation)compilation).generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "test", "Foo_BarHelper__MapperGenerated.java").contentsAsUtf8String().contains((CharSequence)"class Foo_BarHelper__MapperGenerated extends EntityHelperBase<Foo.Bar>");
    }

    @Test
    public void should_detect_boolean_getter() {
        Compilation compilation = this.compileWithMapperProcessor("test", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Foo", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addType(TypeSpec.classBuilder((String)"Bar").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Entity.class).addMethod(MethodSpec.methodBuilder((String)"setBool").addParameter(TypeName.BOOLEAN, "bool", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build()).addMethod(MethodSpec.methodBuilder((String)"isBool").returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return true", new Object[0]).build()).build()).build());
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        StringSubject contents = CompilationSubject.assertThat((Compilation)compilation).generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "test", "Foo_BarHelper__MapperGenerated.java").contentsAsUtf8String();
        contents.contains((CharSequence)"target = target.setBoolean(\"bool\", entity.isBool())");
        contents.contains((CharSequence)"returnValue.setBool(source.getBoolean(\"bool\"))");
    }

    @Test
    public void should_fail_on_interface() {
        this.should_fail_with_expected_error("Only CLASS elements can be annotated with Entity", "test", TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"Foo", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Entity.class).build());
    }
}

