/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.internal.mapper.processor.MapperProcessorTest;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.UUID;
import javax.lang.model.element.Modifier;

public abstract class DaoMethodGeneratorTest
extends MapperProcessorTest {
    protected static final ClassName ENTITY_CLASS_NAME = ClassName.get((String)"test", (String)"Product", (String[])new String[0]);
    protected static final TypeSpec ENTITY_SPEC = TypeSpec.classBuilder((ClassName)ENTITY_CLASS_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Entity.class).addField(UUID.class, "id", new Modifier[]{Modifier.PRIVATE}).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"getId").addAnnotation(PartitionKey.class).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).build();
    protected static final ClassName SALE_ENTITY_CLASS_NAME = ClassName.get((String)"test", (String)"ProductSale", (String[])new String[0]);
    protected static final TypeSpec SALE_ENTITY_SPEC = TypeSpec.classBuilder((ClassName)SALE_ENTITY_CLASS_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Entity.class).addField(UUID.class, "id", new Modifier[]{Modifier.PRIVATE}).addField(String.class, "day", new Modifier[]{Modifier.PRIVATE}).addField(UUID.class, "customerId", new Modifier[]{Modifier.PRIVATE}).addField(UUID.class, "ts", new Modifier[]{Modifier.PRIVATE}).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"getId").addAnnotation(PartitionKey.class).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setDay").addParameter(String.class, "day", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.day = day", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"getDay").addAnnotation(AnnotationSpec.builder(PartitionKey.class).addMember("value", "$L", new Object[]{1}).build()).returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return day", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setCustomerId").addParameter(UUID.class, "customerId", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.customerId = customerId", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"getCustomerId").addAnnotation(AnnotationSpec.builder(ClusteringColumn.class).addMember("value", "$L", new Object[]{0}).build()).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return customerId", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setTs").addParameter(UUID.class, "ts", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.ts = ts", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"getTs").addAnnotation(AnnotationSpec.builder(ClusteringColumn.class).addMember("value", "$L", new Object[]{1}).build()).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return ts", new Object[0]).build()).build();

    protected void should_fail_with_expected_error(String expectedError, MethodSpec method) {
        this.should_fail_with_expected_error(expectedError, method, ENTITY_SPEC);
    }

    protected void should_fail_with_expected_error(String expectedError, MethodSpec method, TypeSpec entitySpec) {
        this.should_fail_with_expected_error(expectedError, "test", entitySpec, TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(method).build());
    }

    protected void should_succeed_with_expected_warning(String expectedWarning, MethodSpec method) {
        this.should_succeed_with_expected_warning(expectedWarning, "test", ENTITY_SPEC, TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(method).build());
    }

    protected void should_succeed_without_warnings(MethodSpec method) {
        this.should_succeed_without_warnings("test", ENTITY_SPEC, TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(method).build());
    }
}

