/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.mapper.annotations.SetEntity;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGeneratorTest;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import javax.lang.model.element.Modifier;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DaoSetEntityMethodGeneratorTest
extends DaoMethodGeneratorTest {
    @Override
    @Test
    @UseDataProvider(value="invalidSignatures")
    public void should_fail_with_expected_error(String expectedError, MethodSpec method) {
        super.should_fail_with_expected_error(expectedError, method);
    }

    @DataProvider
    public static Object[][] invalidSignatures() {
        return new Object[][]{{"Wrong number of parameters: SetEntity methods must have two", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"a", (Modifier[])new Modifier[0]).build()).build()}, {"Wrong number of parameters: SetEntity methods must have two", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"a", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(String.class, (String)"b", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(String.class, (String)"c", (Modifier[])new Modifier[0]).build()).build()}, {"Wrong parameter types: SetEntity methods must take a SettableByName and an annotated entity (in any order)", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Integer.class, (String)"target", (Modifier[])new Modifier[0]).build()).build()}, {"Wrong parameter types: SetEntity methods must take a SettableByName and an annotated entity (in any order)", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"entity", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BoundStatement.class, (String)"target", (Modifier[])new Modifier[0]).build()).build()}, {"Invalid return type: SetEntity methods must either be void, or return the same type as their settable parameter (in this case, com.datastax.oss.driver.api.core.cql.BoundStatement to match 'target')", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BoundStatement.class, (String)"target", (Modifier[])new Modifier[0]).build()).returns(Integer.class).build()}, {"Invalid return type: SetEntity methods must either be void, or return the same type as their settable parameter (in this case, com.datastax.oss.driver.api.core.cql.BoundStatement to match 'target')", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BoundStatement.class, (String)"target", (Modifier[])new Modifier[0]).build()).returns(UdtValue.class).build()}};
    }

    @Test
    public void should_warn_when_void_and_target_is_bound_statement() {
        super.should_succeed_with_expected_warning("BoundStatement is immutable, this method will not modify 'target' in place. It should probably return BoundStatement rather than void", MethodSpec.methodBuilder((String)"set").addAnnotation(SetEntity.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BoundStatement.class, (String)"target", (Modifier[])new Modifier[0]).build()).build());
    }
}

