/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingGenerator {
    private final boolean logsEnabled;

    public LoggingGenerator(boolean logsEnabled) {
        this.logsEnabled = logsEnabled;
    }

    public void addLoggerField(TypeSpec.Builder classBuilder, ClassName className) {
        if (this.logsEnabled) {
            classBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(Logger.class), (String)"LOG", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$T.getLogger($T.class)", new Object[]{LoggerFactory.class, className}).build());
        }
    }

    public void debug(MethodSpec.Builder builder, String template, CodeBlock ... arguments) {
        if (this.logsEnabled) {
            builder.addCode("$[LOG.debug($S", new Object[]{template});
            for (CodeBlock argument : arguments) {
                builder.addCode(",\n$L", new Object[]{argument});
            }
            builder.addCode(");$]\n", new Object[0]);
        }
    }
}

