/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.dao.NullSavingStrategyValidation;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.BindableHandlingSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultUpdate;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DaoUpdateMethodGenerator
extends DaoMethodGenerator {
    private final NullSavingStrategyValidation nullSavingStrategyValidation;

    public DaoUpdateMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
        this.nullSavingStrategyValidation = new NullSavingStrategyValidation(context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.VOID, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_VOID, (Object)DefaultDaoReturnTypeKind.RESULT_SET, (Object)DefaultDaoReturnTypeKind.BOUND_STATEMENT, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_RESULT_SET, (Object)DefaultDaoReturnTypeKind.BOOLEAN, (Object[])new DaoReturnTypeKind[]{DefaultDaoReturnTypeKind.FUTURE_OF_BOOLEAN, DefaultDaoReturnTypeKind.REACTIVE_RESULT_SET, DefaultDaoReturnTypeKind.CUSTOM});
    }

    @Override
    public boolean requiresReactive() {
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Update.class.getSimpleName());
        if (returnType == null) {
            return false;
        }
        return returnType.requiresReactive();
    }

    @Override
    public Optional<MethodSpec> generate() {
        TypeElement entityElement;
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        TypeElement typeElement = entityElement = parameters.isEmpty() ? null : EntityUtils.asEntityElement(parameters.get(0), (Map<Name, TypeElement>)this.typeParameters);
        if (entityElement == null) {
            this.context.getMessager().error(this.methodElement, this.processedType, "%s methods must take the entity to update as the first parameter", Update.class.getSimpleName());
            return Optional.empty();
        }
        this.warnIfCqlNamePresent(parameters.subList(0, 1));
        EntityDefinition entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Update.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName));
        CodeBlock.Builder createStatementBlock = CodeBlock.builder();
        createStatementBlock.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(createStatementBlock, this.methodElement);
        this.populateBuilderWithFunction(createStatementBlock, boundStatementFunction);
        String entityParameterName = parameters.get(0).getSimpleName().toString();
        Update annotation = this.methodElement.getAnnotation(Update.class);
        String customWhereClause = annotation.customWhereClause();
        NullSavingStrategy nullSavingStrategy = this.nullSavingStrategyValidation.getNullSavingStrategy(Update.class, Update::nullSavingStrategy, this.methodElement, this.enclosingClass);
        if (customWhereClause.isEmpty()) {
            createStatementBlock.addStatement("$1L.set($2L, boundStatementBuilder, $3T.$4L)", new Object[]{helperFieldName, entityParameterName, NullSavingStrategy.class, nullSavingStrategy});
        } else {
            createStatementBlock.addStatement("$1T nullSavingStrategy = $1T.$2L", new Object[]{NullSavingStrategy.class, nullSavingStrategy});
            for (PropertyDefinition property : entityDefinition.getRegularColumns()) {
                GeneratedCodePatterns.setValue(property.getCqlName(), property.getType(), CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{entityParameterName, property.getGetterName()}), "boundStatementBuilder", createStatementBlock, (BindableHandlingSharedCode)this.enclosingClass, true);
            }
        }
        if (parameters.size() > 1) {
            List<? extends VariableElement> bindMarkers = parameters.subList(1, parameters.size());
            if (this.validateCqlNamesPresent(bindMarkers)) {
                GeneratedCodePatterns.bindParameters(bindMarkers, createStatementBlock, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        createStatementBlock.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        return this.crudMethod(createStatementBlock, returnType, helperFieldName);
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName) {
        Update annotation = this.methodElement.getAnnotation(Update.class);
        this.maybeAddWhereClause(methodBuilder, requestName, helperFieldName, annotation.customWhereClause());
        this.maybeAddTtl(annotation.ttl(), methodBuilder);
        this.maybeAddTimestamp(annotation.timestamp(), methodBuilder);
        methodBuilder.addCode(")", new Object[0]);
        this.maybeAddIfClause(methodBuilder, annotation);
        methodBuilder.addCode(".asCql()", new Object[0]);
        methodBuilder.addCode(")$];\n", new Object[0]);
    }

    private void maybeAddWhereClause(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName, String customWhereClause) {
        if (customWhereClause.isEmpty()) {
            methodBuilder.addCode("$[$1T $2L = $1T.newInstance((($4T)$3L.updateByPrimaryKey()", new Object[]{SimpleStatement.class, requestName, helperFieldName, DefaultUpdate.class});
        } else {
            methodBuilder.addCode("$[$1T $2L = $1T.newInstance((($5T)$3L.updateStart().whereRaw($4S)", new Object[]{SimpleStatement.class, requestName, helperFieldName, customWhereClause, DefaultUpdate.class});
        }
    }

    private void maybeAddIfClause(MethodSpec.Builder methodBuilder, Update annotation) {
        if (annotation.ifExists() && !annotation.customIfClause().isEmpty()) {
            this.context.getMessager().error(this.methodElement, this.processedType, "Invalid annotation parameters: %s cannot have both ifExists and customIfClause", Update.class.getSimpleName());
        }
        if (annotation.ifExists()) {
            methodBuilder.addCode(".ifExists()", new Object[0]);
        }
        if (!annotation.customIfClause().isEmpty()) {
            methodBuilder.addCode(".ifRaw($S)", new Object[]{annotation.customIfClause()});
        }
    }
}

