/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.Computed;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.NamingStrategy;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.datastax.oss.driver.api.mapper.annotations.TransientProperties;
import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.CqlNameGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.DefaultEntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.DefaultPropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityFactory;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.AnnotationScanner;
import com.datastax.oss.driver.internal.mapper.processor.util.HierarchyScanner;
import com.datastax.oss.driver.internal.mapper.processor.util.ResolvedAnnotation;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DefaultEntityFactory
implements EntityFactory {
    private final ProcessorContext context;
    private static final Set<Class<? extends Annotation>> EXCLUSIVE_PROPERTY_ANNOTATIONS = ImmutableSet.of(ClusteringColumn.class, PartitionKey.class, Transient.class, Computed.class);
    private static final Set<Class<? extends Annotation>> PROPERTY_ANNOTATIONS = ImmutableSet.builder().addAll(EXCLUSIVE_PROPERTY_ANNOTATIONS).add(CqlName.class).build();

    public DefaultEntityFactory(ProcessorContext context) {
        this.context = context;
    }

    @Override
    public EntityDefinition getDefinition(TypeElement processedClass) {
        Set<TypeMirror> types = HierarchyScanner.resolveTypeHierarchy(processedClass, this.context);
        LinkedHashSet typeHierarchy = Sets.newLinkedHashSet();
        for (TypeMirror type : types) {
            typeHierarchy.add((TypeElement)this.context.getTypeUtils().asElement(type));
        }
        CqlNameGenerator cqlNameGenerator = this.buildCqlNameGenerator(typeHierarchy);
        Set<String> transientProperties = this.getTransientPropertyNames(typeHierarchy);
        HashSet encounteredPropertyNames = Sets.newHashSet();
        TreeMap<Integer, DefaultPropertyDefinition> partitionKey = new TreeMap<Integer, DefaultPropertyDefinition>();
        TreeMap<Integer, DefaultPropertyDefinition> clusteringColumns = new TreeMap<Integer, DefaultPropertyDefinition>();
        ImmutableList.Builder regularColumns = ImmutableList.builder();
        ImmutableList.Builder computedValues = ImmutableList.builder();
        for (TypeElement typeElement : typeHierarchy) {
            for (Element element : typeElement.getEnclosedElements()) {
                PropertyDefinition previous;
                VariableElement field;
                Map<Class<? extends Annotation>, Annotation> propertyAnnotations;
                ExecutableElement setMethod;
                String setMethodName;
                String propertyName;
                boolean booleanGetterName;
                TypeMirror typeMirror;
                ExecutableElement getMethod;
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !(getMethod = (ExecutableElement)element).getParameters().isEmpty() || (typeMirror = getMethod.getReturnType()).getKind() == TypeKind.VOID) continue;
                String getMethodName = getMethod.getSimpleName().toString();
                boolean regularGetterName = getMethodName.startsWith("get");
                boolean bl = booleanGetterName = getMethodName.startsWith("is") && (typeMirror.getKind() == TypeKind.BOOLEAN || this.context.getClassUtils().isSame(typeMirror, Boolean.class));
                if (!regularGetterName && !booleanGetterName) continue;
                if (regularGetterName) {
                    propertyName = Introspector.decapitalize(getMethodName.substring(3));
                    setMethodName = getMethodName.replaceFirst("get", "set");
                } else {
                    propertyName = Introspector.decapitalize(getMethodName.substring(2));
                    setMethodName = getMethodName.replaceFirst("is", "set");
                }
                if (encounteredPropertyNames.contains(propertyName) || (setMethod = this.findSetMethod(typeHierarchy, setMethodName, typeMirror)) == null || this.isTransient(propertyAnnotations = this.scanPropertyAnnotations(typeHierarchy, getMethod, field = this.findField(typeHierarchy, propertyName, typeMirror), processedClass), propertyName, transientProperties, getMethod, field, processedClass)) continue;
                int partitionKeyIndex = this.getPartitionKeyIndex(propertyAnnotations);
                int clusteringColumnIndex = this.getClusteringColumnIndex(propertyAnnotations);
                Optional<String> customCqlName = this.getCustomCqlName(propertyAnnotations);
                Optional<String> computedFormula = this.getComputedFormula(propertyAnnotations, getMethod, field, processedClass);
                PropertyType propertyType = PropertyType.parse(typeMirror, this.context);
                DefaultPropertyDefinition property = new DefaultPropertyDefinition(propertyName, customCqlName, computedFormula, getMethodName, setMethodName, propertyType, cqlNameGenerator);
                encounteredPropertyNames.add(propertyName);
                if (partitionKeyIndex >= 0) {
                    previous = partitionKey.putIfAbsent(partitionKeyIndex, property);
                    if (previous == null) continue;
                    this.context.getMessager().error(getMethod, processedClass, "Duplicate partition key index: if multiple properties are annotated with @%s, the annotation must be parameterized with an integer indicating the position. Found duplicate index %d for %s and %s.", PartitionKey.class.getSimpleName(), partitionKeyIndex, previous.getGetterName(), property.getGetterName());
                    continue;
                }
                if (clusteringColumnIndex >= 0) {
                    previous = clusteringColumns.putIfAbsent(clusteringColumnIndex, property);
                    if (previous == null) continue;
                    this.context.getMessager().error(getMethod, processedClass, "Duplicate clustering column index: if multiple properties are annotated with @%s, the annotation must be parameterized with an integer indicating the position. Found duplicate index %d for %s and %s.", ClusteringColumn.class.getSimpleName(), clusteringColumnIndex, previous.getGetterName(), property.getGetterName());
                    continue;
                }
                if (computedFormula.isPresent()) {
                    computedValues.add((Object)property);
                    continue;
                }
                regularColumns.add((Object)property);
            }
        }
        if (encounteredPropertyNames.isEmpty()) {
            this.context.getMessager().error(processedClass, "@%s-annotated class must have at least one property defined.", Entity.class.getSimpleName());
        }
        String entityName = Introspector.decapitalize(processedClass.getSimpleName().toString());
        String defaultKeyspace = processedClass.getAnnotation(Entity.class).defaultKeyspace();
        return new DefaultEntityDefinition(ClassName.get((TypeElement)processedClass), entityName, defaultKeyspace.isEmpty() ? null : defaultKeyspace, Optional.ofNullable(processedClass.getAnnotation(CqlName.class)).map(CqlName::value), (List<PropertyDefinition>)ImmutableList.copyOf(partitionKey.values()), (List<PropertyDefinition>)ImmutableList.copyOf(clusteringColumns.values()), (List<PropertyDefinition>)regularColumns.build(), (List<PropertyDefinition>)computedValues.build(), cqlNameGenerator);
    }

    @Nullable
    private VariableElement findField(Set<TypeElement> typeHierarchy, String propertyName, TypeMirror fieldType) {
        for (TypeElement classElement : typeHierarchy) {
            if (classElement.getKind().isInterface()) continue;
            for (Element element : classElement.getEnclosedElements()) {
                VariableElement field;
                if (element.getKind() != ElementKind.FIELD || !(field = (VariableElement)element).getSimpleName().toString().equals(propertyName) || !this.context.getTypeUtils().isAssignable(fieldType, field.asType())) continue;
                return field;
            }
        }
        return null;
    }

    @Nullable
    private ExecutableElement findSetMethod(Set<TypeElement> typeHierarchy, String setMethodName, TypeMirror fieldType) {
        for (TypeElement classElement : typeHierarchy) {
            for (Element element : classElement.getEnclosedElements()) {
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) continue;
                ExecutableElement setMethod = (ExecutableElement)element;
                List<? extends VariableElement> parameters = setMethod.getParameters();
                if (!setMethod.getSimpleName().toString().equals(setMethodName) || parameters.size() != 1 || !this.context.getTypeUtils().isAssignable(fieldType, parameters.get(0).asType())) continue;
                return setMethod;
            }
        }
        return null;
    }

    private Optional<String> getCustomCqlName(Map<Class<? extends Annotation>, Annotation> annotations) {
        CqlName cqlName = (CqlName)annotations.get(CqlName.class);
        return cqlName != null ? Optional.of(cqlName.value()) : Optional.empty();
    }

    private int getPartitionKeyIndex(Map<Class<? extends Annotation>, Annotation> annotations) {
        PartitionKey partitionKey = (PartitionKey)annotations.get(PartitionKey.class);
        return partitionKey != null ? partitionKey.value() : -1;
    }

    private int getClusteringColumnIndex(Map<Class<? extends Annotation>, Annotation> annotations) {
        ClusteringColumn clusteringColumn = (ClusteringColumn)annotations.get(ClusteringColumn.class);
        return clusteringColumn != null ? clusteringColumn.value() : -1;
    }

    private Optional<String> getComputedFormula(Map<Class<? extends Annotation>, Annotation> annotations, ExecutableElement getMethod, @Nullable VariableElement field, TypeElement processedClass) {
        Computed annotation = (Computed)annotations.get(Computed.class);
        if (annotation != null) {
            String value = annotation.value();
            if (value.isEmpty()) {
                ExecutableElement element = field != null && field.getAnnotation(Computed.class) != null ? field : getMethod;
                this.context.getMessager().error(element, processedClass, "@Computed value should be non-empty.", new Object[0]);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private CqlNameGenerator buildCqlNameGenerator(Set<TypeElement> typeHierarchy) {
        Optional<ResolvedAnnotation<NamingStrategy>> annotation = AnnotationScanner.getClassAnnotation(NamingStrategy.class, typeHierarchy);
        if (!annotation.isPresent()) {
            return CqlNameGenerator.DEFAULT;
        }
        NamingStrategy namingStrategy = annotation.get().getAnnotation();
        TypeElement classElement = (TypeElement)annotation.get().getElement();
        if (namingStrategy == null) {
            return CqlNameGenerator.DEFAULT;
        }
        NamingConvention[] conventions = namingStrategy.convention();
        TypeMirror[] customConverterClasses = this.readCustomConverterClasses(classElement);
        if (conventions.length > 0 && customConverterClasses.length > 0) {
            this.context.getMessager().error(classElement, "Invalid annotation configuration: %s must have either a 'convention' or 'customConverterClass' argument, but not both", NamingStrategy.class.getSimpleName());
            return new CqlNameGenerator(conventions[0]);
        }
        if (conventions.length == 0 && customConverterClasses.length == 0) {
            this.context.getMessager().error(classElement, "Invalid annotation configuration: %s must have either a 'convention' or 'customConverterClass' argument", NamingStrategy.class.getSimpleName());
            return CqlNameGenerator.DEFAULT;
        }
        if (conventions.length > 0) {
            if (conventions.length > 1) {
                this.context.getMessager().warn(classElement, "Too many naming conventions: %s must have at most one 'convention' argument (will use the first one: %s)", NamingStrategy.class.getSimpleName(), conventions[0]);
            }
            return new CqlNameGenerator(conventions[0]);
        }
        if (customConverterClasses.length > 1) {
            this.context.getMessager().warn(classElement, "Too many custom converters: %s must have at most one 'customConverterClass' argument (will use the first one: %s)", NamingStrategy.class.getSimpleName(), customConverterClasses[0]);
        }
        return new CqlNameGenerator(customConverterClasses[0]);
    }

    private TypeMirror[] readCustomConverterClasses(Element classElement) {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : classElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror2.getAnnotationType(), NamingStrategy.class)) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        assert (annotationMirror != null);
        for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("customConverterClass")) continue;
            List values = (List)((AnnotationValue)entry.getValue()).getValue();
            TypeMirror[] result = new TypeMirror[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                result[i] = (TypeMirror)((AnnotationValue)values.get(i)).getValue();
            }
            return result;
        }
        return new TypeMirror[0];
    }

    private boolean isTransient(Map<Class<? extends Annotation>, Annotation> annotations, String propertyName, Set<String> transientProperties, ExecutableElement getMethod, @Nullable VariableElement field, TypeElement processedClass) {
        Transient transientAnnotation = (Transient)annotations.get(Transient.class);
        boolean isTransient = transientProperties.contains(propertyName) || transientAnnotation != null || field != null && field.getModifiers().contains((Object)Modifier.TRANSIENT);
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        if (isTransient && transientAnnotation == null && exclusiveAnnotation != null) {
            Element element = field != null ? field : getMethod;
            this.context.getMessager().error(element, processedClass, "Property that is considered transient cannot be annotated with @%s.", exclusiveAnnotation.getSimpleName());
        }
        return isTransient;
    }

    private Set<String> getTransientPropertyNames(Set<TypeElement> typeHierarchy) {
        Optional<ResolvedAnnotation<TransientProperties>> annotation = AnnotationScanner.getClassAnnotation(TransientProperties.class, typeHierarchy);
        return annotation.isPresent() ? Sets.newHashSet((Object[])annotation.get().getAnnotation().value()) : Collections.emptySet();
    }

    private void reportMultipleAnnotationError(Element element, Class<? extends Annotation> a0, Class<? extends Annotation> a1, TypeElement processedClass) {
        if (a0 == a1) {
            this.context.getMessager().warn(element, processedClass, "@%s should be used either on the field or the getter, but not both. The annotation on this field will be ignored.", a0.getSimpleName());
        } else {
            this.context.getMessager().error(element, processedClass, "Properties can't be annotated with both @%s and @%s.", a0.getSimpleName(), a1.getSimpleName());
        }
    }

    private Map<Class<? extends Annotation>, Annotation> scanPropertyAnnotations(Set<TypeElement> typeHierarchy, ExecutableElement getMethod, @Nullable VariableElement field, TypeElement processedClass) {
        HashMap annotations = Maps.newHashMap();
        this.scanMethodAnnotations(typeHierarchy, getMethod, annotations, processedClass);
        if (field != null) {
            this.scanFieldAnnotations(field, annotations, processedClass);
        }
        return ImmutableMap.copyOf((Map)annotations);
    }

    @Nullable
    private Class<? extends Annotation> getExclusiveAnnotation(Map<Class<? extends Annotation>, Annotation> annotations) {
        for (Class<? extends Annotation> annotationClass : annotations.keySet()) {
            if (!EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) continue;
            return annotationClass;
        }
        return null;
    }

    private void scanFieldAnnotations(VariableElement field, Map<Class<? extends Annotation>, Annotation> annotations, TypeElement processedClass) {
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        for (Class<? extends Annotation> annotationClass : PROPERTY_ANNOTATIONS) {
            Annotation annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            if (EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) {
                if (exclusiveAnnotation == null) {
                    exclusiveAnnotation = annotationClass;
                } else {
                    this.reportMultipleAnnotationError(field, exclusiveAnnotation, annotationClass, processedClass);
                }
            }
            if (annotations.containsKey(annotationClass)) continue;
            annotations.put(annotationClass, annotation);
        }
    }

    private void scanMethodAnnotations(Set<TypeElement> typeHierarchy, ExecutableElement getMethod, Map<Class<? extends Annotation>, Annotation> annotations, TypeElement processedClass) {
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        for (Class<? extends Annotation> annotationClass : PROPERTY_ANNOTATIONS) {
            Optional<ResolvedAnnotation<? extends Annotation>> annotation = AnnotationScanner.getMethodAnnotation(annotationClass, getMethod, typeHierarchy);
            if (!annotation.isPresent()) continue;
            if (EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) {
                if (exclusiveAnnotation == null) {
                    exclusiveAnnotation = annotationClass;
                } else {
                    this.reportMultipleAnnotationError(annotation.get().getElement(), exclusiveAnnotation, annotationClass, processedClass);
                }
            }
            if (annotations.containsKey(annotationClass)) continue;
            annotations.put(annotationClass, annotation.get().getAnnotation());
        }
    }
}

