/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.entity;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.mapper.entity.EntityHelperBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class EntityHelperBaseTest {
    @Test
    @UseDataProvider(value="typesProvider")
    public void should_find_not_matching_types(Map<CqlIdentifier, GenericType<?>> entityColumns, Map<CqlIdentifier, ColumnMetadata> cqlColumns, List<String> expected) {
        List missingTypes = EntityHelperBase.findTypeMismatches(entityColumns, cqlColumns, (CodecRegistry)CodecRegistry.DEFAULT);
        AssertionsForInterfaceTypes.assertThat((List)missingTypes).isEqualTo(expected);
    }

    @Test
    public void should_throw_if_there_is_not_matching_cql_column() {
        ImmutableMap entityColumns = ImmutableMap.of((Object)CqlIdentifier.fromCql((String)"c1"), (Object)GenericType.of(Integer.class));
        ColumnMetadata columnMetadataInt = (ColumnMetadata)Mockito.mock(ColumnMetadata.class);
        Mockito.when((Object)columnMetadataInt.getType()).thenReturn((Object)DataTypes.INT);
        ImmutableMap cqlColumns = ImmutableMap.of((Object)CqlIdentifier.fromCql((String)"c2"), (Object)columnMetadataInt);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> EntityHelperBase.findTypeMismatches((Map)entityColumns, (Map)cqlColumns, (CodecRegistry)CodecRegistry.DEFAULT)).isInstanceOf(AssertionError.class)).hasMessageContaining("There is no cql column for entity column: c1");
    }

    @DataProvider
    public static Object[][] typesProvider() {
        ColumnMetadata columnMetadataText = (ColumnMetadata)Mockito.mock(ColumnMetadata.class);
        Mockito.when((Object)columnMetadataText.getType()).thenReturn((Object)DataTypes.TEXT);
        ColumnMetadata columnMetadataInt = (ColumnMetadata)Mockito.mock(ColumnMetadata.class);
        Mockito.when((Object)columnMetadataInt.getType()).thenReturn((Object)DataTypes.INT);
        CqlIdentifier c1 = CqlIdentifier.fromCql((String)"c1");
        CqlIdentifier c2 = CqlIdentifier.fromCql((String)"c2");
        return new Object[][]{{ImmutableMap.of((Object)c1, (Object)GenericType.of(String.class)), ImmutableMap.of((Object)c1, (Object)columnMetadataText), Collections.emptyList()}, {ImmutableMap.of((Object)c1, (Object)GenericType.of(Integer.class)), ImmutableMap.of((Object)c1, (Object)columnMetadataText), ImmutableList.of((Object)"Field: c1, Entity Type: java.lang.Integer, CQL type: TEXT")}, {ImmutableMap.of((Object)c1, (Object)GenericType.of(String.class), (Object)c2, (Object)GenericType.of(Integer.class)), ImmutableMap.of((Object)c1, (Object)columnMetadataText, (Object)c2, (Object)columnMetadataInt), Collections.emptyList()}, {ImmutableMap.of((Object)c1, (Object)GenericType.of(String.class), (Object)c2, (Object)GenericType.of(Integer.class)), ImmutableMap.of((Object)c1, (Object)columnMetadataInt, (Object)c2, (Object)columnMetadataText), ImmutableList.of((Object)"Field: c1, Entity Type: java.lang.String, CQL type: INT", (Object)"Field: c2, Entity Type: java.lang.Integer, CQL type: TEXT")}};
    }
}

