/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.internal.mapper.processor.entity.CqlNameGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.squareup.javapoet.CodeBlock;
import java.util.Optional;

public class DefaultPropertyDefinition
implements PropertyDefinition {
    private final CodeBlock selector;
    private final CodeBlock cqlName;
    private final String getterName;
    private final String setterName;
    private final PropertyType type;

    public DefaultPropertyDefinition(String javaName, Optional<String> customCqlName, Optional<String> computedFormula, String getterName, String setterName, PropertyType type, CqlNameGenerator cqlNameGenerator) {
        this.cqlName = customCqlName.map(n -> CodeBlock.of((String)"$S", (Object[])new Object[]{n})).orElse(cqlNameGenerator.buildCqlName(javaName));
        this.selector = computedFormula.map(n -> CodeBlock.of((String)"$S", (Object[])new Object[]{n})).orElse(this.cqlName);
        this.getterName = getterName;
        this.setterName = setterName;
        this.type = type;
    }

    @Override
    public CodeBlock getSelector() {
        return this.selector;
    }

    @Override
    public CodeBlock getCqlName() {
        return this.cqlName;
    }

    @Override
    public String getGetterName() {
        return this.getterName;
    }

    @Override
    public String getSetterName() {
        return this.setterName;
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }
}

