/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.Computed;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.datastax.oss.driver.internal.mapper.processor.MapperProcessorTest;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.UUID;
import javax.lang.model.element.Modifier;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class EntityPropertyAnnotationsTest
extends MapperProcessorTest {
    @Test
    @UseDataProvider(value="entitiesWithWarnings")
    public void should_succeed_with_expected_warning(String expectedWarning, TypeSpec entitySpec) {
        super.should_succeed_with_expected_warning(expectedWarning, "test", entitySpec);
    }

    @DataProvider
    public static Object[][] entitiesWithWarnings() {
        return new Object[][]{{"@PartitionKey should be used either on the field or the getter, but not both. The annotation on this field will be ignored.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(PartitionKey.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").addAnnotation(PartitionKey.class).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"@ClusteringColumn should be used either on the field or the getter, but not both. The annotation on this field will be ignored.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(ClusteringColumn.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").addAnnotation(ClusteringColumn.class).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}};
    }

    @Test
    @UseDataProvider(value="entitiesWithErrors")
    public void should_fail_with_expected_error(String expectedError, TypeSpec entitySpec) {
        super.should_fail_with_expected_error(expectedError, "test", entitySpec);
    }

    @DataProvider
    public static Object[][] entitiesWithErrors() {
        return new Object[][]{{"Properties can't be annotated with both @ClusteringColumn and @PartitionKey.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(PartitionKey.class).addAnnotation(ClusteringColumn.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"Properties can't be annotated with both @ClusteringColumn and @PartitionKey.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(PartitionKey.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").addAnnotation(ClusteringColumn.class).returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"Duplicate partition key index: if multiple properties are annotated with @PartitionKey, the annotation must be parameterized with an integer indicating the position. Found duplicate index 0 for getId1 and getId2.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id1", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(PartitionKey.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId1").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id1", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId1").addParameter(UUID.class, "id1", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id1 = id1", new Object[0]).build()).addField(FieldSpec.builder(UUID.class, (String)"id2", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(PartitionKey.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId2").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id2", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId2").addParameter(UUID.class, "id2", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id2 = id2", new Object[0]).build()).build()}, {"Duplicate clustering column index: if multiple properties are annotated with @ClusteringColumn, the annotation must be parameterized with an integer indicating the position. Found duplicate index 1 for getId1 and getId2.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id1", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(ClusteringColumn.class).addMember("value", "1", new Object[0]).build()).build()).addMethod(MethodSpec.methodBuilder((String)"getId1").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id1", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId1").addParameter(UUID.class, "id1", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id1 = id1", new Object[0]).build()).addField(FieldSpec.builder(UUID.class, (String)"id2", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(ClusteringColumn.class).addMember("value", "1", new Object[0]).build()).build()).addMethod(MethodSpec.methodBuilder((String)"getId2").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id2", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId2").addParameter(UUID.class, "id2", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id2 = id2", new Object[0]).build()).build()}, {"Properties can't be annotated with both @ClusteringColumn and @Transient.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(ClusteringColumn.class).addAnnotation(Transient.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"Property that is considered transient cannot be annotated with @PartitionKey.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.TRANSIENT}).addAnnotation(PartitionKey.class).build()).addMethod(MethodSpec.methodBuilder((String)"getId").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"@Computed value should be non-empty.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(Computed.class).addMember("value", "$S", new Object[]{""}).build()).build()).addMethod(MethodSpec.methodBuilder((String)"getId").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"setId").addParameter(UUID.class, "id", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.id = id", new Object[0]).build()).build()}, {"@Entity-annotated class must have at least one property defined.", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Product", (String[])new String[0])).addAnnotation(Entity.class).addField(FieldSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"getId").returns(UUID.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return id", new Object[0]).build()).build()}};
    }
}

