/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.mapper.processor.util.Capitalizer;
import org.junit.Test;

public class CapitalizerTest {
    @Test
    public void should_decapitalize_regular_strings() {
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"foo")).isEqualTo("foo");
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"Foo")).isEqualTo("foo");
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"FooBar")).isEqualTo("fooBar");
    }

    @Test
    public void should_not_decapitalize_when_second_char_is_uppercase() {
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"ID")).isEqualTo("ID");
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"XML")).isEqualTo("XML");
        Assertions.assertThat((String)Capitalizer.decapitalize((String)"XMLRequest")).isEqualTo("XMLRequest");
    }

    @Test
    public void should_capitalize_regular_strings() {
        Assertions.assertThat((String)Capitalizer.capitalize((String)"foo")).isEqualTo("Foo");
        Assertions.assertThat((String)Capitalizer.capitalize((String)"fooBar")).isEqualTo("FooBar");
    }

    @Test
    public void should_not_capitalize_when_second_char_is_uppercase() {
        Assertions.assertThat((String)Capitalizer.capitalize((String)"cId")).isEqualTo("cId");
    }

    @Test
    public void should_infer_field_name_and_setter_from_getter() {
        String getterName = "getcId";
        String fieldName = Capitalizer.decapitalize((String)getterName.substring(3));
        String setterName = "set" + Capitalizer.capitalize((String)fieldName);
        Assertions.assertThat((String)fieldName).isEqualTo("cId");
        Assertions.assertThat((String)setterName).isEqualTo("setcId");
    }
}

