/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.buffer;

import com.devops4j.embedded.buffer.Bits;
import com.devops4j.embedded.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

class HeapByteBuf
extends ByteBuf {
    byte[] data = null;
    int writeBegin = 0;
    int writeEnd = 0;
    int readBegin = 0;
    int readEnd = 0;
    boolean readonly = false;
    boolean autoExpand = false;
    boolean bigEndian = false;

    public HeapByteBuf(byte[] data) {
        this.data = data;
        this.writeBegin = 0;
        this.writeEnd = data.length;
        this.readBegin = 0;
        this.readEnd = data.length;
    }

    public HeapByteBuf(int size) {
        this.data = new byte[size];
        this.writeBegin = 0;
        this.writeEnd = this.data.length;
        this.readBegin = 0;
        this.readEnd = 0;
    }

    @Override
    public boolean bigEndian() {
        return this.bigEndian;
    }

    @Override
    public ByteBuf bigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
        return this;
    }

    @Override
    public int capacity() {
        return this.data.length;
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.expendData(newCapacity);
        return this;
    }

    void expendData(int newCapacity) {
        byte[] temp = new byte[newCapacity];
        if (newCapacity > this.data.length) {
            System.arraycopy(this.data, 0, temp, 0, this.data.length);
        } else {
            System.arraycopy(this.data, 0, temp, 0, newCapacity);
            this.readEnd = newCapacity - 1;
        }
        this.data = temp;
        this.writeEnd = newCapacity - 1;
    }

    @Override
    public int maxCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    @Override
    public ByteBuf autoExpand(boolean expand) {
        this.autoExpand = expand;
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public ByteBuf readOnly(boolean readOnly) {
        this.readonly = readOnly;
        return this;
    }

    @Override
    public ByteBuf clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
        this.writeBegin = 0;
        this.writeEnd = this.data.length;
        this.readBegin = 0;
        this.readEnd = 0;
        return this;
    }

    @Override
    public ByteBuf put(byte v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        if (this.writableLength() < 1) {
            if (this.autoExpand) {
                double newCap = Math.round((double)this.data.length * 1.75);
                this.expendData(Math.max((int)newCap, this.data.length + 1));
            } else {
                throw new ArrayIndexOutOfBoundsException("buffer is out of bounds!");
            }
        }
        this.data[this.writeBegin] = v;
        ++this.writeBegin;
        ++this.readEnd;
        return this;
    }

    @Override
    public ByteBuf put(short v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        if (this.bigEndian) {
            this.put(Bits.short1(v));
            this.put(Bits.short0(v));
        } else {
            this.put(Bits.short0(v));
            this.put(Bits.short1(v));
        }
        return this;
    }

    @Override
    public ByteBuf put(int v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        if (this.bigEndian) {
            this.put(Bits.int3(v));
            this.put(Bits.int2(v));
            this.put(Bits.int1(v));
            this.put(Bits.int0(v));
        } else {
            this.put(Bits.int0(v));
            this.put(Bits.int1(v));
            this.put(Bits.int2(v));
            this.put(Bits.int3(v));
        }
        return this;
    }

    @Override
    public ByteBuf put(long v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        if (this.bigEndian) {
            this.put(Bits.long7(v));
            this.put(Bits.long6(v));
            this.put(Bits.long5(v));
            this.put(Bits.long4(v));
            this.put(Bits.long3(v));
            this.put(Bits.long2(v));
            this.put(Bits.long1(v));
            this.put(Bits.long0(v));
        } else {
            this.put(Bits.long0(v));
            this.put(Bits.long1(v));
            this.put(Bits.long2(v));
            this.put(Bits.long3(v));
            this.put(Bits.long4(v));
            this.put(Bits.long5(v));
            this.put(Bits.long6(v));
            this.put(Bits.long7(v));
        }
        return this;
    }

    @Override
    public ByteBuf put(float v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        this.put(Float.floatToRawIntBits(v));
        return this;
    }

    @Override
    public ByteBuf put(double v) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        this.put(Double.doubleToRawLongBits(v));
        return this;
    }

    @Override
    public ByteBuf put(byte[] bytes) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        int length = bytes.length;
        if (this.writableLength() < length) {
            if (this.autoExpand) {
                int newCap = (int)((double)this.data.length * 1.75);
                this.expendData(Math.max(newCap, this.data.length + length));
            } else {
                throw new ArrayIndexOutOfBoundsException("buffer is out of bounds!");
            }
        }
        System.arraycopy(bytes, 0, this.data, this.writeBegin, length);
        this.writeBegin += length;
        this.readEnd += length;
        return this;
    }

    @Override
    public ByteBuf put(String charset, String ... strings) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        for (String str : strings) {
            try {
                byte[] temp = str.getBytes(charset);
                this.put(temp);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public ByteBuf put(ByteBuffer buffer) {
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        this.put(buffer.array());
        return this;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public byte[] getBytes(int length) {
        byte[] temp = new byte[length];
        this.get(temp);
        return temp;
    }

    @Override
    public ByteBuf get(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        int length = data.length;
        if (this.readableLength() < length) {
            throw new ArrayIndexOutOfBoundsException("buffer is out of bounds!");
        }
        System.arraycopy(this.data, this.readBegin, data, 0, length);
        this.readBegin += length;
        return this;
    }

    @Override
    public ByteBuf resetRead() {
        this.readBegin = 0;
        return this;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        byte[] temp = new byte[this.readableLength()];
        this.get(temp);
        return ByteBuffer.wrap(temp);
    }

    @Override
    public ByteArrayInputStream asInputStream() {
        return new ByteArrayInputStream(this.getBytes(this.readableLength()));
    }

    @Override
    public int read(InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("InputStream is null!");
        }
        if (this.readonly) {
            throw new IllegalArgumentException("buffer is readonly!");
        }
        int byteLen = 0;
        int byteReadLen = 0;
        byte[] data = new byte[1024];
        while ((byteReadLen = is.read(data)) != -1) {
            if (byteReadLen == 1024) {
                this.put(data);
            } else {
                byte[] data0 = new byte[byteReadLen];
                System.arraycopy(data, 0, data0, 0, byteReadLen);
                this.put(data0);
            }
            byteLen += byteReadLen;
        }
        return byteLen;
    }

    @Override
    public int write(OutputStream os) throws IOException {
        if (os == null) {
            throw new NullPointerException("OutputStream is null!");
        }
        int byteLen = 0;
        int byteWriteLen = 0;
        while ((byteWriteLen = this.readableLength()) > 0) {
            byte[] data = new byte[Math.min(1024, byteWriteLen)];
            byteLen += data.length;
            this.get(data);
            os.write(data);
        }
        return byteLen;
    }

    @Override
    public int readableLength() {
        return this.readEnd - this.readBegin;
    }

    @Override
    public int writableLength() {
        return this.writeEnd - this.writeBegin;
    }

    @Override
    public ByteBuf get(ByteBuffer buffer) {
        int length = this.readableLength();
        if (buffer.remaining() < length) {
            throw new ArrayIndexOutOfBoundsException("spaces is not enough!");
        }
        byte[] temp = new byte[length];
        this.get(temp);
        buffer.put(temp);
        return this;
    }

    @Override
    public String asString(String charset) {
        return this.getString(charset, this.readableLength());
    }

    @Override
    public String getString(String charset, int length) {
        byte[] temp = new byte[length];
        this.get(temp);
        String str = null;
        try {
            str = new String(temp, charset);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte getByte() {
        if (this.readableLength() < 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte b = this.data[this.readBegin++];
        return b;
    }

    @Override
    public short getShort() {
        byte[] temp = new byte[2];
        this.get(temp);
        return this.bigEndian ? Bits.makeShort(temp[0], temp[1]) : Bits.makeShort(temp[1], temp[0]);
    }

    @Override
    public int getInt() {
        byte[] temp = new byte[4];
        this.get(temp);
        return this.bigEndian ? Bits.makeInt(temp[0], temp[1], temp[2], temp[3]) : Bits.makeInt(temp[3], temp[2], temp[1], temp[0]);
    }

    @Override
    public long getLong() {
        byte[] temp = new byte[8];
        this.get(temp);
        return this.bigEndian ? Bits.makeLong(temp[0], temp[1], temp[2], temp[3], temp[4], temp[5], temp[6], temp[7]) : Bits.makeLong(temp[7], temp[6], temp[5], temp[4], temp[3], temp[2], temp[1], temp[0]);
    }

    @Override
    public float getFloat() {
        int v = this.getInt();
        return Float.intBitsToFloat(v);
    }

    @Override
    public double getDouble() {
        long v = this.getLong();
        return Double.longBitsToDouble(v);
    }
}

