/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.github.service;

import com.dipien.github.IRepositoryIdProvider;
import com.dipien.github.Repository;
import com.dipien.github.Team;
import com.dipien.github.TeamMembership;
import com.dipien.github.User;
import com.dipien.github.client.GitHubClient;
import com.dipien.github.client.GitHubRequest;
import com.dipien.github.client.PagedRequest;
import com.dipien.github.service.GitHubService;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;

public class TeamService
extends GitHubService {
    public TeamService() {
    }

    public TeamService(GitHubClient client) {
        super(client);
    }

    public Team getTeam(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Team.class));
        return (Team)this.client.get(request).getBody();
    }

    public List<Team> getTeams(String organization) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/teams");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Team>>(){}.getType());
        return this.getAll(request);
    }

    public Team createTeam(String organization, Team team) throws IOException {
        return this.createTeam(organization, team, null);
    }

    public Team createTeam(String organization, Team team, List<String> repoNames) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (team == null) {
            throw new IllegalArgumentException("Team cannot be null");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/teams");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", team.getName());
        params.put("permission", team.getPermission());
        if (repoNames != null) {
            params.put("repo_names", repoNames);
        }
        return (Team)this.client.post(uri.toString(), params, (Type)((Object)Team.class));
    }

    public Team editTeam(Team team) throws IOException {
        if (team == null) {
            throw new IllegalArgumentException("Team cannot be null");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(team.getId());
        return (Team)this.client.post(uri.toString(), team, (Type)((Object)Team.class));
    }

    public void deleteTeam(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }

    public List<User> getMembers(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/members");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request);
    }

    public boolean isMember(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/members");
        uri.append('/').append(user);
        return this.check(uri.toString());
    }

    public void addMember(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/members");
        uri.append('/').append(user);
        this.client.put(uri.toString());
    }

    public void removeMember(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/members");
        uri.append('/').append(user);
        this.client.delete(uri.toString());
    }

    public TeamMembership getMembership(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/memberships");
        uri.append('/').append(user);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)TeamMembership.class));
        return (TeamMembership)this.client.get(request).getBody();
    }

    public TeamMembership addMembership(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/memberships");
        uri.append('/').append(user);
        return (TeamMembership)this.client.put(uri.toString(), null, (Type)((Object)TeamMembership.class));
    }

    public void removeMembership(int id, String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/memberships");
        uri.append('/').append(user);
        this.client.delete(uri.toString());
    }

    public List<Repository> getRepositories(int id) throws IOException {
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/repos");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.getAll(request);
    }

    public boolean isTeamRepository(int id, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/repos");
        uri.append('/').append(repoId);
        return this.check(uri.toString());
    }

    public void addRepository(int id, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/repos");
        uri.append('/').append(repoId);
        this.client.put(uri.toString());
    }

    public void removeRepository(int id, IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/teams");
        uri.append('/').append(id);
        uri.append("/repos");
        uri.append('/').append(repoId);
        this.client.delete(uri.toString());
    }

    public List<Team> getTeams(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/teams");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Team>>(){}.getType());
        return this.getAll(request);
    }
}

