/*
 * Decompiled with CFR 0.152.
 */
package com.docspring;

import com.docspring.ApiClient;
import com.docspring.AuthenticationSuccessResponse;
import com.docspring.CreateSubmissionDataRequestData;
import com.docspring.CreateSubmissionResponse;
import com.docspring.PdfApi;
import com.docspring.PendingTemplate;
import com.docspring.Submission;
import com.docspring.SubmissionData;
import com.docspring.SubmissionDataRequest;
import com.docspring.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class PdfApiIntegrationTest {
    private PdfApi api;
    private static final Logger logger = LoggerFactory.getLogger(PdfApiIntegrationTest.class);

    @Before
    public void setup() {
        ApiClient client = new ApiClient("api_token_basic", "api_token123", "testsecret123");
        client.getAdapterBuilder().baseUrl("http://api.docspring.local:31337/api/v1/");
        this.api = (PdfApi)client.createService(PdfApi.class);
    }

    @Test
    public void addFieldsToTemplateTest() {
        Object templateId = null;
        Object addFieldsData = null;
    }

    @Test
    public void batchGeneratePdfV1Test() {
        Object templateId = null;
        Object requestBody = null;
    }

    @Test
    public void batchGeneratePdfsTest() {
        Object submissionBatchData = null;
    }

    @Test
    public void combinePdfsTest() {
        Object combinePdfsData = null;
    }

    @Test
    public void combineSubmissionsTest() {
        Object combinedSubmissionData = null;
    }

    @Test
    public void createCustomFileFromUploadTest() {
        Object createCustomFileData = null;
    }

    @Test
    public void createDataRequestTokenTest() {
        Object dataRequestId = null;
    }

    @Test
    public void createFolderTest() {
        Object createFolderData = null;
    }

    @Test
    public void createHTMLTemplateTest() {
        Object createHtmlTemplateData = null;
    }

    @Test
    public void createPDFTemplateTest() throws IOException {
        String templateParentFolderId;
        String templateName;
        File templateDocumentFile = new File("../../test_fixtures/first_last_signature.pdf");
        RequestBody templateDocumentRequestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/pdf"), (File)templateDocumentFile);
        MultipartBody.Part templateDocumentPart = MultipartBody.Part.createFormData((String)"PDF", (String)templateDocumentFile.getName(), (RequestBody)templateDocumentRequestBody);
        Response retrofitResponse = this.api.createPDFTemplate(templateDocumentPart, templateName = "New Uploaded Template", templateParentFolderId = null).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        PendingTemplate template = (PendingTemplate)retrofitResponse.body();
        MatcherAssert.assertThat((Object)template.getId(), (Matcher)Matchers.startsWith((String)"tpl_"));
        Assert.assertEquals((Object)template.getName(), (Object)"New Uploaded Template");
    }

    @Test
    public void deleteFolderTest() {
        Object folderId = null;
    }

    @Test
    public void expireCombinedSubmissionTest() {
        Object combinedSubmissionId = null;
    }

    @Test
    public void expireSubmissionTest() {
        Object submissionId = null;
    }

    @Test
    public void generatePDFTest() throws IOException {
        String templateId = "tpl_000000000000000001";
        SubmissionData submissionData = new SubmissionData();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", "Test PDF");
        data.put("description", "This PDF is great!");
        submissionData.setData(data);
        HashMap fieldOverrides = new HashMap();
        HashMap<String, Boolean> requiredMap = new HashMap<String, Boolean>();
        requiredMap.put("required", false);
        fieldOverrides.put("title", requiredMap);
        submissionData.setFieldOverrides(fieldOverrides);
        Response retrofitResponse = this.api.generatePDF(templateId, submissionData).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        CreateSubmissionResponse response = (CreateSubmissionResponse)retrofitResponse.body();
        Submission submission = response.getSubmission();
        Assert.assertEquals((long)201L, (long)retrofitResponse.code());
        Assert.assertEquals((Object)CreateSubmissionResponse.StatusEnum.SUCCESS, (Object)response.getStatus());
        MatcherAssert.assertThat((Object)submission.getId(), (Matcher)Matchers.startsWith((String)"sub_"));
        Assert.assertEquals((Object)false, (Object)submission.getExpired());
        Assert.assertEquals((Object)Submission.StateEnum.PENDING, (Object)submission.getState());
    }

    @Test
    public void generatePDFWithDataRequestTest() throws IOException {
        String templateId = "tpl_000000000000000001";
        SubmissionData submissionData = new SubmissionData();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", "Test PDF");
        data.put("description", "This PDF is great!");
        submissionData.setData(data);
        ArrayList<CreateSubmissionDataRequestData> dataRequestsList = new ArrayList<CreateSubmissionDataRequestData>();
        CreateSubmissionDataRequestData dataRequestData = new CreateSubmissionDataRequestData();
        dataRequestData.setAuthType(CreateSubmissionDataRequestData.AuthTypeEnum.EMAIL_LINK);
        dataRequestData.setName("John Smith");
        dataRequestData.setEmail("jsmith@example.com");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("description");
        dataRequestData.setFields(fields);
        dataRequestsList.add(dataRequestData);
        submissionData.setDataRequests(dataRequestsList);
        Response retrofitResponse = this.api.generatePDF(templateId, submissionData).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        Assert.assertEquals((long)201L, (long)retrofitResponse.code());
        CreateSubmissionResponse response = (CreateSubmissionResponse)retrofitResponse.body();
        Assert.assertEquals((Object)CreateSubmissionResponse.StatusEnum.SUCCESS, (Object)response.getStatus());
        Submission submission = response.getSubmission();
        MatcherAssert.assertThat((Object)submission.getId(), (Matcher)Matchers.startsWith((String)"sub_"));
        Assert.assertEquals((Object)false, (Object)submission.getExpired());
        Assert.assertEquals((Object)Submission.StateEnum.WAITING_FOR_DATA_REQUESTS, (Object)submission.getState());
        Assert.assertEquals((long)1L, (long)submission.getDataRequests().size());
        SubmissionDataRequest dataRequest = (SubmissionDataRequest)submission.getDataRequests().get(0);
        MatcherAssert.assertThat((Object)dataRequest.getId(), (Matcher)Matchers.startsWith((String)"drq_"));
        Assert.assertEquals((Object)SubmissionDataRequest.StateEnum.PENDING, (Object)dataRequest.getState());
        MatcherAssert.assertThat((Object)dataRequest.getFields(), (Matcher)CoreMatchers.is(Arrays.asList("description")));
        Assert.assertEquals((Object)new Integer(0), (Object)new Integer(dataRequest.getOrder()));
        Assert.assertEquals((Object)"John Smith", (Object)dataRequest.getName());
        Assert.assertEquals((Object)"jsmith@example.com", (Object)dataRequest.getEmail());
    }

    @Test
    public void getCombinedSubmissionTest() {
        Object combinedSubmissionId = null;
    }

    @Test
    public void getDataRequestTest() {
        Object dataRequestId = null;
    }

    @Test
    public void getPresignUrlTest() {
    }

    @Test
    public void getSubmissionTest() {
        Object submissionId = null;
        Object includeData = null;
    }

    @Test
    public void getSubmissionBatchTest() {
        Object submissionBatchId = null;
        Object includeSubmissions = null;
    }

    @Test
    public void getTemplateTest() {
        Object templateId = null;
    }

    @Test
    public void getTemplateSchemaTest() {
        Object templateId = null;
    }

    @Test
    public void listFoldersTest() {
        Object parentFolderId = null;
    }

    @Test
    public void listTemplatesTest() throws IOException {
        Integer perPage;
        String query = "API Client Test Template 2";
        Integer page = 1;
        Response retrofitResponse = this.api.listTemplates(query, null, page, perPage = Integer.valueOf(10)).execute();
        if (!retrofitResponse.isSuccessful()) {
            logger.info(retrofitResponse.errorBody().string());
        }
        Assert.assertEquals((long)200L, (long)retrofitResponse.code());
        List response = (List)retrofitResponse.body();
        Assert.assertEquals((long)1L, (long)response.size());
        Assert.assertEquals((Object)"tpl_000000000000000002", (Object)((Template)response.get(0)).getId());
    }

    @Test
    public void moveFolderToFolderTest() {
        Object folderId = null;
        Object moveFolderData = null;
    }

    @Test
    public void moveTemplateToFolderTest() {
        Object templateId = null;
        Object moveTemplateData = null;
    }

    @Test
    public void renameFolderTest() {
        Object folderId = null;
        Object renameFolderData = null;
    }

    @Test
    public void testAuthenticationTest() throws IOException {
        Response response = this.api.testAuthentication().execute();
        Assert.assertEquals((Object)AuthenticationSuccessResponse.StatusEnum.SUCCESS, (Object)((AuthenticationSuccessResponse)response.body()).getStatus());
    }

    @Test
    public void updateDataRequestTest() {
        Object dataRequestId = null;
        Object updateSubmissionDataRequestData = null;
    }

    @Test
    public void updateTemplateTest() {
        Object templateId = null;
        Object updateTemplateData = null;
    }
}

