/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client.auth;

import com.docusign.esign.client.Pair;
import com.docusign.esign.client.auth.AccessTokenListener;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.OAuthFlow;
import com.docusign.esign.client.auth.OAuthJerseyClient;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;

public class OAuth
implements Authentication {
    static final int MILLIS_PER_SECOND = 1000;
    public static final String Scope_SIGNATURE = "signature";
    public static final String Scope_EXTENDED = "extended";
    public static final String Scope_IMPERSONATION = "impersonation";
    public static final String CODE = "code";
    public static final String TOKEN = "token";
    private volatile String accessToken;
    private Long expirationTimeMillis;
    private OAuthClient oauthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    private AccessTokenListener accessTokenListener;

    public OAuth(Client client, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder, OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
        this.tokenRequestBuilder = tokenRequestBuilder;
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuth(Client client, OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(client, OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes), OAuthClientRequest.authorizationLocation((String)authorizationUrl).setScope(scopes));
        switch (flow) {
            case accessCode: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                this.authenticationRequestBuilder.setResponseType(CODE);
                break;
            }
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                this.authenticationRequestBuilder.setResponseType(TOKEN);
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(new Client(null, null), flow, authorizationUrl, tokenUrl, scopes);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (headerParams.containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.updateAccessToken();
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    public synchronized void updateAccessToken() {
        OAuthJSONAccessTokenResponse accessTokenResponse;
        try {
            accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
        }
        catch (Exception e) {
            throw new ClientHandlerException(e.getMessage(), (Throwable)e);
        }
        if (accessTokenResponse != null) {
            if (accessTokenResponse.getResponseCode() != Response.Status.OK.getStatusCode()) {
                throw new ClientHandlerException("Error while requesting an access token, received HTTP code: " + accessTokenResponse.getResponseCode());
            }
            if (accessTokenResponse.getAccessToken() == null) {
                throw new ClientHandlerException("Error while requesting an access token. No 'access_token' found.");
            }
            if (accessTokenResponse.getExpiresIn() == null) {
                throw new ClientHandlerException("Error while requesting an access token. No 'expires_in' found.");
            }
            this.setAccessToken(accessTokenResponse.getAccessToken(), accessTokenResponse.getExpiresIn());
            if (this.accessTokenListener != null) {
                this.accessTokenListener.notify((BasicOAuthToken)accessTokenResponse.getOAuthToken());
            }
        } else {
            throw new ClientHandlerException("Error while requesting an access token. No accessTokenResponse object recieved, maybe a non HTTP 200 received?");
        }
    }

    public synchronized void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken, Long expiresIn) {
        this.accessToken = accessToken;
        this.expirationTimeMillis = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public void setAuthenticationRequestBuilder(OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuthClient getOauthClient() {
        return this.oauthClient;
    }

    public void setOauthClient(OAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    public void setOauthClient(Client client) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UserInfo {
        @JsonProperty(value="sub")
        private String sub = null;
        @JsonProperty(value="email")
        private String email = null;
        @JsonProperty(value="accounts")
        private List<Account> accounts = new ArrayList<Account>();
        @JsonProperty(value="name")
        private String name = null;
        @JsonProperty(value="given_name")
        private String givenName = null;
        @JsonProperty(value="family_name")
        private String familyName = null;
        @JsonProperty(value="created")
        private String created = null;

        public UserInfo sub(String sub) {
            this.sub = sub;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getSub() {
            return this.sub;
        }

        public void setSub(String sub) {
            this.sub = sub;
        }

        public UserInfo email(String email) {
            this.email = email;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public UserInfo accounts(List<Account> accounts) {
            this.accounts = accounts;
            return this;
        }

        public UserInfo addAccountsItem(Account accountsItem) {
            this.accounts.add(accountsItem);
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public List<Account> getAccounts() {
            return this.accounts;
        }

        public void setAccounts(List<Account> accounts) {
            this.accounts = accounts;
        }

        public UserInfo name(String name) {
            this.name = name;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UserInfo givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public UserInfo familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public UserInfo created(String created) {
            this.created = created;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getCreated() {
            return this.created;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserInfo userInfo = (UserInfo)o;
            return Objects.equals(this.sub, userInfo.sub) && Objects.equals(this.email, userInfo.email) && Objects.equals(this.accounts, userInfo.accounts) && Objects.equals(this.name, userInfo.name) && Objects.equals(this.givenName, userInfo.givenName) && Objects.equals(this.familyName, userInfo.familyName) && Objects.equals(this.created, userInfo.created);
        }

        public int hashCode() {
            return Objects.hash(this.sub, this.email, this.accounts, this.name, this.givenName, this.familyName, this.created);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class UserInfo {\n");
            sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
            sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
            sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
            sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
            sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
            sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Account {
        @JsonProperty(value="account_id")
        private String accountId = null;
        @JsonProperty(value="is_default")
        private String isDefault = null;
        @JsonProperty(value="account_name")
        private String accountName = null;
        @JsonProperty(value="base_uri")
        private String baseUri = null;
        @JsonProperty(value="organization")
        private Organization organization = new Organization();

        public Account accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Account isDefault(String isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getIsDefault() {
            return this.isDefault;
        }

        public void setIsDefault(String isDefault) {
            this.isDefault = isDefault;
        }

        public Account accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public Account baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getBaseUri() {
            return this.baseUri;
        }

        public void setBaseUri(String baseUri) {
            this.baseUri = baseUri;
        }

        public Account organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public Organization getOrganization() {
            return this.organization;
        }

        public void setOrganization(Organization organization) {
            this.organization = organization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.accountId, account.accountId) && Objects.equals(this.isDefault, account.isDefault) && Objects.equals(this.accountName, account.accountName) && Objects.equals(this.baseUri, account.baseUri) && Objects.equals(this.organization, account.organization);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.isDefault, this.accountName, this.baseUri, this.organization);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Account {\n");
            sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
            sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
            sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
            sb.append("    baseUri: ").append(this.toIndentedString(this.baseUri)).append("\n");
            sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Organization {
        @JsonProperty(value="organization_id")
        private String organizationId = null;
        @JsonProperty(value="links")
        private List<Link> links = new ArrayList<Link>();

        public Organization organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getOrganizationId() {
            return this.organizationId;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public Organization links(List<Link> links) {
            this.links = links;
            return this;
        }

        public Organization addLinksItem(Link linksItem) {
            this.links.add(linksItem);
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public List<Link> getLinks() {
            return this.links;
        }

        public void setLinks(List<Link> links) {
            this.links = links;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Organization organization = (Organization)o;
            return Objects.equals(this.organizationId, organization.organizationId) && Objects.equals(this.links, organization.links);
        }

        public int hashCode() {
            return Objects.hash(this.organizationId, this.links);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Organization {\n");
            sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
            sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Link {
        @JsonProperty(value="rel")
        private String rel = null;
        @JsonProperty(value="href")
        private String href = null;

        public Link rel(String rel) {
            this.rel = rel;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getRel() {
            return this.rel;
        }

        public void setRel(String rel) {
            this.rel = rel;
        }

        public Link href(String href) {
            this.href = href;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            return Objects.equals(this.rel, link.rel) && Objects.equals(this.href, link.href);
        }

        public int hashCode() {
            return Objects.hash(this.rel, this.href);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class Link {\n");
            sb.append("    rel: ").append(this.toIndentedString(this.rel)).append("\n");
            sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OAuthToken {
        @JsonProperty(value="access_token")
        private String accessToken = null;
        @JsonProperty(value="token_type")
        private String tokenType = null;
        @JsonProperty(value="refresh_token")
        private String refreshToken = null;
        @JsonProperty(value="expires_in")
        private Long expiresIn = 0L;

        public OAuthToken accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public OAuthToken isTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public OAuthToken refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @ApiModelProperty(example="null", value="")
        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public OAuthToken expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @ApiModelProperty(example="3600L", value="0L")
        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OAuthToken oAuthToken = (OAuthToken)o;
            return Objects.equals(this.accessToken, oAuthToken.accessToken) && Objects.equals(this.tokenType, oAuthToken.tokenType) && Objects.equals(this.refreshToken, oAuthToken.refreshToken) && Objects.equals(this.expiresIn, oAuthToken.expiresIn);
        }

        public int hashCode() {
            return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("class OAuthToken {\n");
            sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
            sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
            sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
            sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
            return sb.toString();
        }

        private String toIndentedString(Object o) {
            if (o == null) {
                return "null";
            }
            return o.toString().replace("\n", "\n    ");
        }
    }
}

