/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.api;

import com.docusign.webforms.client.ApiClient;
import com.docusign.webforms.client.ApiException;
import com.docusign.webforms.client.ApiResponse;
import com.docusign.webforms.client.Configuration;
import com.docusign.webforms.client.Pair;
import com.docusign.webforms.model.CreateInstanceRequestBody;
import com.docusign.webforms.model.WebFormInstance;
import com.docusign.webforms.model.WebFormInstanceList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class FormInstanceManagementApi {
    private ApiClient apiClient;

    public FormInstanceManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FormInstanceManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebFormInstance createInstance(String accountId, String formId, CreateInstanceRequestBody createInstanceBody) throws ApiException {
        ApiResponse<WebFormInstance> localVarResponse = this.createInstanceWithHttpInfo(accountId, formId, createInstanceBody);
        return localVarResponse.getData();
    }

    public ApiResponse<WebFormInstance> createInstanceWithHttpInfo(String accountId, String formId, CreateInstanceRequestBody createInstanceBody) throws ApiException {
        CreateInstanceRequestBody localVarPostBody = createInstanceBody;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createInstance");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling createInstance");
        }
        if (createInstanceBody == null) {
            throw new ApiException(400, "Missing the required parameter 'createInstanceBody' when calling createInstance");
        }
        String localVarPath = "/accounts/{account_id}/forms/{form_id}/instances".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{form_id\\}", this.apiClient.escapeString(formId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebFormInstance> localVarReturnType = new GenericType<WebFormInstance>(){};
        WebFormInstance localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebFormInstance>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WebFormInstance getInstance(String accountId, String formId, String instanceId) throws ApiException {
        ApiResponse<WebFormInstance> localVarResponse = this.getInstanceWithHttpInfo(accountId, formId, instanceId);
        return localVarResponse.getData();
    }

    public ApiResponse<WebFormInstance> getInstanceWithHttpInfo(String accountId, String formId, String instanceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getInstance");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getInstance");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling getInstance");
        }
        String localVarPath = "/accounts/{account_id}/forms/{form_id}/instances/{instance_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{form_id\\}", this.apiClient.escapeString(formId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebFormInstance> localVarReturnType = new GenericType<WebFormInstance>(){};
        WebFormInstance localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebFormInstance>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WebFormInstanceList listInstances(String accountId, String formId) throws ApiException {
        return this.listInstances(accountId, formId, null);
    }

    public WebFormInstanceList listInstances(String accountId, String formId, ListInstancesOptions options) throws ApiException {
        ApiResponse<WebFormInstanceList> localVarResponse = this.listInstancesWithHttpInfo(accountId, formId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WebFormInstanceList> listInstancesWithHttpInfo(String accountId, String formId, ListInstancesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listInstances");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling listInstances");
        }
        String localVarPath = "/accounts/{account_id}/forms/{form_id}/instances".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{form_id\\}", this.apiClient.escapeString(formId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("client_user_id", options.clientUserId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebFormInstanceList> localVarReturnType = new GenericType<WebFormInstanceList>(){};
        WebFormInstanceList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebFormInstanceList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WebFormInstance refreshToken(String accountId, String formId, String instanceId) throws ApiException {
        ApiResponse<WebFormInstance> localVarResponse = this.refreshTokenWithHttpInfo(accountId, formId, instanceId);
        return localVarResponse.getData();
    }

    public ApiResponse<WebFormInstance> refreshTokenWithHttpInfo(String accountId, String formId, String instanceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling refreshToken");
        }
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling refreshToken");
        }
        if (instanceId == null) {
            throw new ApiException(400, "Missing the required parameter 'instanceId' when calling refreshToken");
        }
        String localVarPath = "/accounts/{account_id}/forms/{form_id}/instances/{instance_id}/refresh".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{form_id\\}", this.apiClient.escapeString(formId.toString())).replaceAll("\\{instance_id\\}", this.apiClient.escapeString(instanceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WebFormInstance> localVarReturnType = new GenericType<WebFormInstance>(){};
        WebFormInstance localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WebFormInstance>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListInstancesOptions {
        private String clientUserId = null;

        public void setClientUserId(String clientUserId) {
            this.clientUserId = clientUserId;
        }

        public String getClientUserId() {
            return this.clientUserId;
        }
    }
}

