/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.InstanceStatus;
import com.docusign.webforms.model.WebFormInstanceEnvelopes;
import com.docusign.webforms.model.WebFormInstanceMetadata;
import com.docusign.webforms.model.WebFormValues;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="An object that contains the Web Form Instance required to render it  and its metadata such as created by, created time")
public class WebFormInstance {
    @JsonProperty(value="formUrl")
    private String formUrl = null;
    @JsonProperty(value="instanceToken")
    private String instanceToken = null;
    @JsonProperty(value="tokenExpirationDateTime")
    private String tokenExpirationDateTime = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="formId")
    private String formId = null;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="clientUserId")
    private String clientUserId = null;
    @JsonProperty(value="tags")
    private List<String> tags = null;
    @JsonProperty(value="status")
    private InstanceStatus status = null;
    @JsonProperty(value="envelopes")
    private List<WebFormInstanceEnvelopes> envelopes = null;
    @JsonProperty(value="instanceMetadata")
    private WebFormInstanceMetadata instanceMetadata = null;
    @JsonProperty(value="formValues")
    private WebFormValues formValues = null;

    public WebFormInstance formUrl(String formUrl) {
        this.formUrl = formUrl;
        return this;
    }

    @Schema(description="")
    public String getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    public WebFormInstance instanceToken(String instanceToken) {
        this.instanceToken = instanceToken;
        return this;
    }

    @Schema(description="")
    public String getInstanceToken() {
        return this.instanceToken;
    }

    public void setInstanceToken(String instanceToken) {
        this.instanceToken = instanceToken;
    }

    public WebFormInstance tokenExpirationDateTime(String tokenExpirationDateTime) {
        this.tokenExpirationDateTime = tokenExpirationDateTime;
        return this;
    }

    @Schema(description="")
    public String getTokenExpirationDateTime() {
        return this.tokenExpirationDateTime;
    }

    public void setTokenExpirationDateTime(String tokenExpirationDateTime) {
        this.tokenExpirationDateTime = tokenExpirationDateTime;
    }

    public WebFormInstance id(String id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebFormInstance formId(String formId) {
        this.formId = formId;
        return this;
    }

    @Schema(description="Web form from which the instance is created")
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public WebFormInstance accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public WebFormInstance clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Schema(description="")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public WebFormInstance tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public WebFormInstance addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Schema(example="[\"loan_application\",\"finance_dept\"]", description="List of tags provided by the user with each request. This field is optional.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public WebFormInstance status(InstanceStatus status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    public InstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status;
    }

    public WebFormInstance envelopes(List<WebFormInstanceEnvelopes> envelopes) {
        this.envelopes = envelopes;
        return this;
    }

    public WebFormInstance addEnvelopesItem(WebFormInstanceEnvelopes envelopesItem) {
        if (this.envelopes == null) {
            this.envelopes = new ArrayList<WebFormInstanceEnvelopes>();
        }
        this.envelopes.add(envelopesItem);
        return this;
    }

    @Schema(description="The associated envelope that is created when the instance is submitted")
    public List<WebFormInstanceEnvelopes> getEnvelopes() {
        return this.envelopes;
    }

    public void setEnvelopes(List<WebFormInstanceEnvelopes> envelopes) {
        this.envelopes = envelopes;
    }

    public WebFormInstance instanceMetadata(WebFormInstanceMetadata instanceMetadata) {
        this.instanceMetadata = instanceMetadata;
        return this;
    }

    @Schema(description="")
    public WebFormInstanceMetadata getInstanceMetadata() {
        return this.instanceMetadata;
    }

    public void setInstanceMetadata(WebFormInstanceMetadata instanceMetadata) {
        this.instanceMetadata = instanceMetadata;
    }

    public WebFormInstance formValues(WebFormValues formValues) {
        this.formValues = formValues;
        return this;
    }

    @Schema(description="")
    public WebFormValues getFormValues() {
        return this.formValues;
    }

    public void setFormValues(WebFormValues formValues) {
        this.formValues = formValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormInstance webFormInstance = (WebFormInstance)o;
        return Objects.equals(this.formUrl, webFormInstance.formUrl) && Objects.equals(this.instanceToken, webFormInstance.instanceToken) && Objects.equals(this.tokenExpirationDateTime, webFormInstance.tokenExpirationDateTime) && Objects.equals(this.id, webFormInstance.id) && Objects.equals(this.formId, webFormInstance.formId) && Objects.equals(this.accountId, webFormInstance.accountId) && Objects.equals(this.clientUserId, webFormInstance.clientUserId) && Objects.equals(this.tags, webFormInstance.tags) && Objects.equals((Object)this.status, (Object)webFormInstance.status) && Objects.equals(this.envelopes, webFormInstance.envelopes) && Objects.equals(this.instanceMetadata, webFormInstance.instanceMetadata) && Objects.equals(this.formValues, webFormInstance.formValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formUrl, this.instanceToken, this.tokenExpirationDateTime, this.id, this.formId, this.accountId, this.clientUserId, this.tags, this.status, this.envelopes, this.instanceMetadata, this.formValues});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormInstance {\n");
        sb.append("    formUrl: ").append(this.toIndentedString(this.formUrl)).append("\n");
        sb.append("    instanceToken: ").append(this.toIndentedString(this.instanceToken)).append("\n");
        sb.append("    tokenExpirationDateTime: ").append(this.toIndentedString(this.tokenExpirationDateTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    formId: ").append(this.toIndentedString(this.formId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    envelopes: ").append(this.toIndentedString(this.envelopes)).append("\n");
        sb.append("    instanceMetadata: ").append(this.toIndentedString(this.instanceMetadata)).append("\n");
        sb.append("    formValues: ").append(this.toIndentedString(this.formValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

