/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractMatrix;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicLongMatrix
extends AbstractMatrix {
    private long[] values;

    public BasicLongMatrix(int rows, int columns) {
        super(rows, columns);
        this.values = new long[rows * columns];
    }

    public BasicLongMatrix(int rows, int columns, List<long[]> list) throws Exception {
        super(rows, columns);
        this.values = new long[rows * columns];
        if (list == null || list.size() != columns) {
            throw new Exception("input list of arrays does not have " + columns + " columns");
        }
        for (int i = 0; i < columns; ++i) {
            long[] array = list.get(i);
            if (array == null || array.length != rows) {
                throw new Exception("The length of array " + (i + 1) + " doesn't have " + rows + " elements");
            }
            System.arraycopy(array, 0, this.values, i * rows, rows);
        }
    }

    public BasicLongMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setLong(int row, int column, long value) {
        this.values[this.getIndex((int)row, (int)column)] = value;
    }

    public long getLong(int row, int column) {
        return this.values[this.getIndex(row, column)];
    }

    @Override
    public boolean isNull(int row, int column) {
        return this.values[this.getIndex(row, column)] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int row, int column) {
        this.values[this.getIndex((int)row, (int)column)] = Long.MIN_VALUE;
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicLong(this.values[this.getIndex(row, column)]);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_LONG;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicLong.class;
    }

    @Override
    protected void readMatrixFromInputStream(int rows, int columns, ExtendedDataInput in) throws IOException {
        int size = rows * columns;
        this.values = new long[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readLong();
        }
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (long value : this.values) {
            out.writeLong(value);
        }
    }
}

