/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageHandler;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.LockSupport;

public class ThreadPooledClient
extends AbstractClient {
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private ExecutorService threadPool;
    private HashMap<String, QueueHandlerBinder> queueHandlers = new HashMap();

    public ThreadPooledClient() throws SocketException {
        this(8849, CORES);
    }

    public ThreadPooledClient(int subscribePort, int threadCount) throws SocketException {
        super(subscribePort);
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        new Thread(){
            private LinkedList<IMessage> backlog = new LinkedList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean fillBacklog() {
                boolean filled = true;
                HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                synchronized (hashMap) {
                    Set keySet = ThreadPooledClient.this.queueHandlers.keySet();
                    for (String topic : keySet) {
                        List messages = (List)((QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(topic)).queue.poll();
                        if (messages == null) continue;
                        this.backlog.addAll(messages);
                        filled = true;
                    }
                }
                return filled;
            }

            private void refill() {
                int count = 200;
                while (!this.fillBacklog()) {
                    if (count <= 100) {
                        if (count > 0) {
                            Thread.yield();
                        } else {
                            LockSupport.park();
                        }
                    }
                    --count;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    IMessage msg;
                    if ((msg = this.backlog.poll()) != null) {
                        QueueHandlerBinder binder;
                        HashMap hashMap = ThreadPooledClient.this.queueHandlers;
                        synchronized (hashMap) {
                            binder = (QueueHandlerBinder)ThreadPooledClient.this.queueHandlers.get(msg.getTopic());
                        }
                        ThreadPooledClient.this.threadPool.execute(new HandlerRunner(binder.handler, msg));
                        continue;
                    }
                    this.refill();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String host, int port, String tableName, MessageHandler handler, long offset) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, offset);
        HashMap<String, QueueHandlerBinder> hashMap = this.queueHandlers;
        synchronized (hashMap) {
            this.queueHandlers.put((String)this.tableName2Topic.get(host + ":" + port + ":" + tableName), new QueueHandlerBinder(queue, handler));
        }
    }

    public void subscribe(String host, int port, String tableName, MessageHandler handler) throws IOException {
        this.subscribe(host, port, tableName, handler, -1L);
    }

    void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName);
    }

    class HandlerRunner
    implements Runnable {
        MessageHandler handler;
        IMessage message;

        HandlerRunner(MessageHandler handler, IMessage message) {
            this.handler = handler;
            this.message = message;
        }

        @Override
        public void run() {
            this.handler.doEvent(this.message);
        }
    }

    private class QueueHandlerBinder {
        private BlockingQueue<List<IMessage>> queue;
        private MessageHandler handler;

        public QueueHandlerBinder(BlockingQueue<List<IMessage>> queue, MessageHandler handler) {
            this.queue = queue;
            this.handler = handler;
        }
    }
}

