/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.ExtendedDataOutput;
import com.xxdb.io.Long2;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public abstract class AbstractExtendedDataOutputStream
extends FilterOutputStream
implements ExtendedDataOutput {
    private static final int UTF8_STRING_LIMIT = 65535;
    protected static final int BUF_SIZE = 4096;
    protected byte[] buf;
    protected static final int longBufSize = 512;
    protected static final int intBufSize = 1024;
    protected int[] intBuf;
    protected long[] longBuf;

    public AbstractExtendedDataOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        int pos = 0;
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        while (true) {
            if (i < len && pos < this.buf.length - 4) {
                char c;
                if ((c = s.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[pos++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                this.buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            this.write(this.buf, 0, pos);
            pos = 0;
            if (i >= len) break;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String value) throws IOException {
        int len = value.length();
        int i = 0;
        int pos = 0;
        boolean lengthWritten = false;
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        while (true) {
            if (i < len && pos < this.buf.length - 3) {
                char c;
                if ((c = value.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[pos++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                this.buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            if (!lengthWritten) {
                if (i == len) {
                    this.writeShort(pos);
                } else {
                    this.writeShort(AbstractExtendedDataOutputStream.getUTFlength(value, i, pos));
                }
                lengthWritten = true;
            }
            this.write(this.buf, 0, pos);
            pos = 0;
            if (i >= len) break;
        }
    }

    @Override
    public void writeString(String value) throws IOException {
        int len = value.length();
        int i = 0;
        int pos = 0;
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        while (true) {
            if (i < len && pos < this.buf.length - 4) {
                char c;
                if ((c = value.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[pos++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                this.buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            if (i >= len) {
                this.buf[pos++] = 0;
            }
            this.write(this.buf, 0, pos);
            pos = 0;
            if (i >= len) break;
        }
    }

    public static int getUTFlength(String value, int start, int sum) throws IOException {
        int len = value.length();
        for (int i = start; i < len && sum <= 65535; ++i) {
            char c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++sum;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                sum += 2;
                continue;
            }
            sum += 3;
        }
        if (sum > 65535) {
            throw new UTFDataFormatException();
        }
        return sum;
    }

    @Override
    public void writeShortArray(short[] A) throws IOException {
        this.writeShortArray(A, 0, A.length);
    }

    @Override
    public void writeIntArray(int[] A) throws IOException {
        this.writeIntArray(A, 0, A.length);
    }

    @Override
    public void writeLongArray(long[] A) throws IOException {
        this.writeLongArray(A, 0, A.length);
    }

    @Override
    public void writeDoubleArray(double[] A) throws IOException {
        this.writeDoubleArray(A, 0, A.length);
    }

    @Override
    public void writeDoubleArray(double[] A, int startIdx, int len) throws IOException {
        if (this.longBuf == null) {
            this.longBuf = new long[512];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 512) {
                this.writeLongArray(this.longBuf, 0, pos);
                pos = 0;
            }
            this.longBuf[pos++] = Double.doubleToLongBits(A[i]);
        }
        if (pos > 0) {
            this.writeLongArray(this.longBuf, 0, pos);
        }
    }

    @Override
    public void writeFloatArray(float[] A) throws IOException {
        this.writeFloatArray(A, 0, A.length);
    }

    @Override
    public void writeFloatArray(float[] A, int startIdx, int len) throws IOException {
        if (this.intBuf == null) {
            this.intBuf = new int[1024];
        }
        int end = startIdx + len;
        int pos = 0;
        for (int i = startIdx; i < end; ++i) {
            if (pos >= 1024) {
                this.writeIntArray(this.intBuf, 0, pos);
                pos = 0;
            }
            this.intBuf[pos++] = Float.floatToIntBits(A[i]);
        }
        if (pos > 0) {
            this.writeIntArray(this.intBuf, 0, pos);
        }
    }

    @Override
    public void writeStringArray(String[] A) throws IOException {
        this.writeStringArray(A, 0, A.length);
    }

    @Override
    public void writeStringArray(String[] A, int startIdx, int len) throws IOException {
        if (this.buf == null) {
            this.buf = new byte[4096];
        }
        int end = startIdx + len;
        int pos = 0;
        block0: for (int j = startIdx; j < end; ++j) {
            String value = A[j];
            int valueLen = value.length();
            int i = 0;
            while (true) {
                if (i < valueLen && pos < this.buf.length - 4) {
                    char c;
                    if ((c = value.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                        this.buf[pos++] = (byte)c;
                        continue;
                    }
                    if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                        this.buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                        this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                        continue;
                    }
                    this.buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                if (i >= valueLen) {
                    this.buf[pos++] = 0;
                }
                if (pos + 4 >= this.buf.length) {
                    this.write(this.buf, 0, pos);
                    pos = 0;
                }
                if (i >= valueLen) continue block0;
            }
        }
        if (pos > 0) {
            this.write(this.buf, 0, pos);
        }
    }

    @Override
    public void writeLong2Array(Long2[] A) throws IOException {
        this.writeLong2Array(A, 0, A.length);
    }
}

