/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.BigEndianDataInputStream;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.streaming.client.BasicMessage;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.MessageDispatcher;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

class MessageParser
implements Runnable {
    private final int MAX_FORM_VALUE = Entity.DATA_FORM.values().length - 1;
    private final int MAX_TYPE_VALUE = Entity.DATA_TYPE.values().length - 1;
    BufferedInputStream bis = null;
    Socket socket = null;
    MessageDispatcher dispatcher;
    String topic;
    HashMap<String, Integer> nameToIndex = null;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public MessageParser(Socket socket, MessageDispatcher dispatcher) {
        this.socket = socket;
        this.dispatcher = dispatcher;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket socket = this.socket;
        try {
            if (this.bis == null) {
                this.bis = new BufferedInputStream(socket.getInputStream());
            }
            long offset = -1L;
            DataInput in = null;
            block14: while (true) {
                if (in == null) {
                    Boolean isLittle = this.bis.read() != 0;
                    in = isLittle.booleanValue() ? new LittleEndianDataInputStream(this.bis) : new BigEndianDataInputStream(this.bis);
                } else {
                    in.readBoolean();
                }
                in.readLong();
                long msgid = in.readLong();
                if (offset == -1L) {
                    offset = msgid;
                } else assert (offset == msgid);
                this.topic = in.readString();
                short flag = in.readShort();
                BasicEntityFactory factory = new BasicEntityFactory();
                int form = flag >> 8;
                int type = flag & 0xFF;
                if (form < 0 || form > this.MAX_FORM_VALUE) {
                    throw new IOException("Invalid form value: " + form);
                }
                if (type < 0 || type > this.MAX_TYPE_VALUE) {
                    throw new IOException("Invalid type value: " + type);
                }
                Entity.DATA_FORM df = Entity.DATA_FORM.values()[form];
                Entity.DATA_TYPE dt = Entity.DATA_TYPE.values()[type];
                Entity body = factory.createEntity(df, dt, (ExtendedDataInput)in);
                if (body.isTable()) {
                    assert (body.rows() == 0);
                    this.nameToIndex = new HashMap();
                    BasicTable schema = (BasicTable)body;
                    int columns = schema.columns();
                    int i = 0;
                    while (true) {
                        if (i >= columns) continue block14;
                        String name = schema.getColumnName(i);
                        this.nameToIndex.put(name.toLowerCase(), i);
                        ++i;
                    }
                }
                if (!body.isVector()) break;
                BasicAnyVector dTable = (BasicAnyVector)body;
                int colSize = dTable.rows();
                int rowSize = dTable.getEntity(0).rows();
                if (rowSize >= 1) {
                    if (rowSize == 1) {
                        BasicMessage rec = new BasicMessage(msgid, this.topic, dTable, this.nameToIndex);
                        this.dispatcher.dispatch(rec);
                    } else {
                        ArrayList<IMessage> messages = new ArrayList<IMessage>(rowSize);
                        for (int i = 0; i < rowSize; ++i) {
                            BasicAnyVector row = new BasicAnyVector(colSize);
                            for (int j = 0; j < colSize; ++j) {
                                AbstractVector vector = (AbstractVector)dTable.getEntity(j);
                                Scalar entity = vector.get(i);
                                row.setEntity(j, entity);
                            }
                            BasicMessage rec = new BasicMessage(msgid, this.topic, row, this.nameToIndex);
                            messages.add(rec);
                            ++msgid;
                        }
                        this.dispatcher.batchDispatch(messages);
                    }
                }
                this.dispatcher.setMsgId(this.topic, msgid);
                offset += (long)rowSize;
            }
            throw new RuntimeException("message body has an invalid format. Vector or table is expected");
        }
        catch (Exception e) {
            if (this.dispatcher.isClosed(this.topic)) {
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            try {
                this.dispatcher.tryReconnect(this.topic);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }
}

