/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDouble;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicDoubleVector
extends AbstractVector {
    private double[] values;

    public BasicDoubleVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicDoubleVector(List<Double> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicDoubleVector(double[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (double[])array.clone();
    }

    protected BasicDoubleVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new double[size];
    }

    protected BasicDoubleVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new double[size];
        int totalBytes = size * 8;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 8;
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getDouble(i * 8);
            }
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicDouble(this.values[index]);
    }

    public double getDouble(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.isNull() ? -1.7976931348623157E308 : value.getNumber().doubleValue();
    }

    public void setDouble(int index, double value) {
        this.values[index] = value;
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == -1.7976931348623157E308;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = -1.7976931348623157E308;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DOUBLE;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDouble.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeDoubleArray(this.values);
    }
}

