/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.data.Vector;
import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import com.xxdb.streaming.client.TopicPoller;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class PollingClient
extends AbstractClient {
    TopicPoller topicPoller = null;

    public PollingClient(int subscribePort) throws SocketException {
        super(subscribePort);
    }

    @Override
    protected boolean doReconnect(AbstractClient.Site site) {
        try {
            Thread.sleep(1000L);
            BlockingQueue<List<IMessage>> queue = this.subscribeInternal(site.host, site.port, site.tableName, site.actionName, null, site.msgId + 1L, true, site.filter, site.allowExistTopic);
            System.out.println("Successfully reconnected and subscribed " + site.host + ":" + site.port + ":" + site.tableName);
            this.topicPoller.setQueue(queue);
            return true;
        }
        catch (Exception ex) {
            System.out.println("Unable to subscribe table. Will try again after 1 seconds.");
            ex.printStackTrace();
            return false;
        }
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect, Vector filter) throws IOException {
        BlockingQueue<List<IMessage>> queue = this.subscribeInternal(host, port, tableName, actionName, null, offset, reconnect, filter, false);
        this.topicPoller = new TopicPoller(queue);
        return this.topicPoller;
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, reconnect, null);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset, Vector filter) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, false, filter);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, long offset) throws IOException {
        return this.subscribe(host, port, tableName, actionName, offset, false);
    }

    public TopicPoller subscribe(String host, int port, String tableName, long offset) throws IOException {
        return this.subscribe(host, port, tableName, "javaStreamingApi", offset);
    }

    public TopicPoller subscribe(String host, int port, String tableName, long offset, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, "javaStreamingApi", offset, reconnect);
    }

    public TopicPoller subscribe(String host, int port, String tableName) throws IOException {
        return this.subscribe(host, port, tableName, -1L);
    }

    public TopicPoller subscribe(String host, int port, String tableName, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, -1L, reconnect);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName) throws IOException {
        return this.subscribe(host, port, tableName, actionName, -1L);
    }

    public TopicPoller subscribe(String host, int port, String tableName, String actionName, boolean reconnect) throws IOException {
        return this.subscribe(host, port, tableName, actionName, -1L, reconnect);
    }

    public void unsubscribe(String host, int port, String tableName, String actionName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, actionName);
    }

    public void unsubscribe(String host, int port, String tableName) throws IOException {
        this.unsubscribeInternal(host, port, tableName, "javaStreamingApi");
    }
}

