/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.util.List;

public class BasicStringVector
extends AbstractVector {
    private String[] values;
    private boolean isSymbol;

    public BasicStringVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size, false);
    }

    public BasicStringVector(List<String> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
        this.isSymbol = false;
    }

    public BasicStringVector(String[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (String[])array.clone();
        this.isSymbol = false;
    }

    protected BasicStringVector(Entity.DATA_FORM df, int size, boolean isSymbol) {
        super(df);
        this.values = new String[size];
        this.isSymbol = isSymbol;
    }

    protected BasicStringVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int rows = in.readInt();
        int columns = in.readInt();
        int size = rows * columns;
        this.values = new String[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readString();
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicString(this.values[index]);
    }

    public String getString(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.getString();
    }

    public void setString(int index, String value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return BasicString.hashBucket(this.values[index], buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicStringVector v = (BasicStringVector)vector;
        int newSize = this.rows() + v.rows();
        String[] newValue = new String[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicStringVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == null || this.values[index].isEmpty();
    }

    @Override
    public void setNull(int index) {
        this.values[index] = "";
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.LITERAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return this.isSymbol ? Entity.DATA_TYPE.DT_SYMBOL : Entity.DATA_TYPE.DT_STRING;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicString.class;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        for (String str : this.values) {
            out.writeString(str);
        }
    }
}

