/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt128;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.Long2;
import java.io.IOException;

public class BasicIPAddr
extends BasicInt128 {
    public BasicIPAddr(long high, long low) {
        super(high, low);
    }

    BasicIPAddr(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_IPADDR;
    }

    @Override
    public String getString() {
        return BasicIPAddr.getString(this.value);
    }

    public static String getString(Long2 value) {
        if (value.high == 0L && value.low >> 32 == 0L) {
            long ip4 = value.low;
            return String.format("%d.%d.%d.%d", ip4 >> 24, ip4 >> 16 & 0xFFL, ip4 >> 8 & 0xFFL, ip4 & 0xFFL);
        }
        StringBuilder sb = new StringBuilder();
        boolean consecutiveZeros = false;
        int[] data = new int[]{(int)(value.high >> 48), (int)(value.high >> 32 & 0xFFFFL), (int)(value.high >> 16 & 0xFFFFL), (int)(value.high & 0xFFFFL), (int)(value.low >> 48), (int)(value.low >> 32 & 0xFFFFL), (int)(value.low >> 16 & 0xFFFFL), (int)(value.low & 0xFFFFL)};
        for (int i = 0; i < 8; ++i) {
            if (i > 0 && i < 6 && !consecutiveZeros && data[i] == 0 && data[i + 1] == 0) {
                consecutiveZeros = true;
                ++i;
                while (i < 6 && data[i + 1] == 0) {
                    ++i;
                }
            } else {
                sb.append(String.format("%1x", (short)data[i]));
            }
            sb.append(':');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static BasicIPAddr fromString(String name) {
        if (name.length() < 7) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (name.charAt(i) != '.') continue;
            return BasicIPAddr.parseIP4(name);
        }
        return BasicIPAddr.parseIP6(name);
    }

    public static BasicIPAddr parseIP4(String str) {
        int byteIndex = 0;
        long curByte = 0L;
        int len = str.length();
        long low = 0L;
        for (int i = 0; i <= len; ++i) {
            if (i == len || str.charAt(i) == '.') {
                if (curByte < 0L || curByte > 255L || byteIndex > 3) {
                    return null;
                }
                low += curByte << (3 - byteIndex) * 8;
                ++byteIndex;
                curByte = 0L;
                continue;
            }
            char ch = str.charAt(i);
            if (ch < '0' || ch > '9') {
                return null;
            }
            curByte = curByte * 10L + (long)ch - 48L;
        }
        if (byteIndex != 4) {
            return null;
        }
        return new BasicIPAddr(0L, low);
    }

    public static BasicIPAddr parseIP6(String str) {
        int byteIndex = 0;
        int curByte = 0;
        int len = str.length();
        int lastColonPos = -1;
        byte[] buf = new byte[16];
        for (int i = 0; i <= len; ++i) {
            if (i == len || str.charAt(i) == ':') {
                if (lastColonPos == i - 1) {
                    int colons = byteIndex / 2;
                    for (int k = i + 1; k < len; ++k) {
                        if (str.charAt(k) != ':') continue;
                        ++colons;
                    }
                    int consecutiveZeros = (7 - colons) * 2;
                    for (int k = 0; k < consecutiveZeros; ++k) {
                        buf[byteIndex++] = 0;
                    }
                } else {
                    if (curByte < 0 || curByte > 65535 || byteIndex > 15) {
                        return null;
                    }
                    buf[byteIndex++] = (byte)(curByte >> 8);
                    buf[byteIndex++] = (byte)(curByte & 0xFF);
                    curByte = 0;
                }
                lastColonPos = i;
                continue;
            }
            char ch = str.charAt(i);
            char value = (char)(ch >= 'a' ? ch - 87 : (ch >= 'A' ? ch - 55 : ch - 48));
            if (value < '\u0000' || value > '\u000f') {
                return null;
            }
            curByte = (curByte << 4) + value;
        }
        if (byteIndex == 16) {
            long low = ((long)buf[8] & 0xFFL) << 56 | ((long)buf[9] & 0xFFL) << 48 | ((long)buf[10] & 0xFFL) << 40 | ((long)buf[11] & 0xFFL) << 32 | ((long)buf[12] & 0xFFL) << 24 | ((long)buf[13] & 0xFFL) << 16 | ((long)buf[14] & 0xFFL) << 8 | (long)buf[15] & 0xFFL;
            long high = ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
            return new BasicIPAddr(high, low);
        }
        return null;
    }
}

