/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;

public class Utils {
    public static final int DISPLAY_ROWS = 20;
    public static final int DISPLAY_COLS = 100;
    public static final int DISPLAY_WIDTH = 100;
    private static final int[] cumMonthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] cumLeapMonthDays = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] leapMonthDays = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final long MILLS_PER_DAY = 86400000L;

    public static int countMonths(YearMonth date) {
        return date.getYear() * 12 + date.getMonthValue() - 1;
    }

    public static int countMonths(int year, int month) {
        return year * 12 + month - 1;
    }

    public static YearMonth parseMonth(int value) {
        return YearMonth.of(value / 12, value % 12 + 1);
    }

    public static int countDays(LocalDate date) {
        return Utils.countDays(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static int countDays(int year, int month, int day) {
        if (month < 1 || month > 12 || day < 0) {
            return Integer.MIN_VALUE;
        }
        int divide400Years = year / 400;
        int offset400Years = year % 400;
        int days = divide400Years * 146097 + offset400Years * 365 - 719529;
        if (offset400Years > 0) {
            days += (offset400Years - 1) / 4 + 1 - (offset400Years - 1) / 100;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return day <= leapMonthDays[month - 1] ? (days += cumLeapMonthDays[month - 1]) + day : Integer.MIN_VALUE;
        }
        return day <= monthDays[month - 1] ? (days += cumMonthDays[month - 1]) + day : Integer.MIN_VALUE;
    }

    public static LocalDate parseDate(int days) {
        int day;
        int month;
        boolean leap;
        int circleIn400Years = (days += 719529) / 146097;
        int offsetIn400Years = days % 146097;
        int resultYear = circleIn400Years * 400;
        int similarYears = offsetIn400Years / 365;
        int tmpDays = similarYears * 365;
        if (similarYears > 0) {
            tmpDays += (similarYears - 1) / 4 + 1 - (similarYears - 1) / 100;
        }
        if (tmpDays >= offsetIn400Years) {
            --similarYears;
        }
        int year = similarYears + resultYear;
        boolean bl = leap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        if ((days -= circleIn400Years * 146097 + tmpDays) <= 0) {
            days += leap ? 366 : 365;
        }
        if (leap) {
            month = days / 32 + 1;
            if (days > cumLeapMonthDays[month]) {
                ++month;
            }
            day = days - cumLeapMonthDays[month - 1];
        } else {
            month = days / 32 + 1;
            if (days > cumMonthDays[month]) {
                ++month;
            }
            day = days - cumMonthDays[month - 1];
        }
        return LocalDate.of(year, month, day);
    }

    public static int countSeconds(LocalDateTime dt) {
        return Utils.countSeconds(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond());
    }

    public static int countSeconds(int year, int month, int day, int hour, int minute, int second) {
        int days = Utils.countDays(year, month, day);
        return days * 86400 + (hour * 60 + minute) * 60 + second;
    }

    public static LocalDateTime parseDateTime(int seconds) {
        int days = seconds / 86400;
        LocalDate date = seconds >= 0 ? Utils.parseDate(days) : Utils.parseDate(days - 1);
        if ((seconds %= 86400) < 0) {
            seconds += 86400;
        }
        int hour = seconds / 3600;
        int minute = (seconds %= 3600) / 60;
        int second = seconds % 60;
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), hour, minute, second);
    }

    public static long countMilliseconds(LocalDateTime dt) {
        long seconds = Utils.countSeconds(dt);
        return seconds * 1000L + (long)(dt.getNano() / 1000000);
    }

    public static long countMilliseconds(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return (long)Utils.countSeconds(year, month, day, hour, minute, second) * 1000L + (long)millisecond;
    }

    public static long countNanoseconds(LocalDateTime dt) {
        long seconds = Utils.countSeconds(dt);
        return seconds * 1000000000L + (long)dt.getNano();
    }

    public static LocalDateTime parseTimestamp(long milliseconds) {
        int days = (int)Math.floor((double)milliseconds / 8.64E7);
        LocalDate date = Utils.parseDate(days);
        if ((milliseconds %= 86400000L) < 0L) {
            milliseconds += 86400000L;
        }
        int millisecond = (int)(milliseconds % 1000L);
        int seconds = (int)(milliseconds / 1000L);
        int hour = seconds / 3600;
        int minute = (seconds %= 3600) / 60;
        int second = seconds % 60;
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), hour, minute, second, millisecond * 1000000);
    }

    public static LocalDateTime parseNanoTimestamp(long nanoseconds) {
        int days = (int)Math.floor((double)nanoseconds / 8.64E13);
        LocalDate date = Utils.parseDate(days);
        if ((nanoseconds %= 86400000000000L) < 0L) {
            nanoseconds += 86400000000000L;
        }
        LocalTime time = Utils.parseNanoTime(nanoseconds % 86400000000000L);
        return LocalDateTime.of(date, time);
    }

    public static int countMilliseconds(LocalTime time) {
        return Utils.countMilliseconds(time.getHour(), time.getMinute(), time.getSecond(), time.getNano() / 1000000);
    }

    public static int countMilliseconds(int hour, int minute, int second, int millisecond) {
        return ((hour * 60 + minute) * 60 + second) * 1000 + millisecond;
    }

    public static long countNanoseconds(LocalTime time) {
        return (long)Utils.countMilliseconds(time.getHour(), time.getMinute(), time.getSecond(), 0) * 1000000L + (long)time.getNano();
    }

    public static LocalTime parseTime(int milliseconds) {
        return LocalTime.of(milliseconds / 3600000, milliseconds / 60000 % 60, milliseconds / 1000 % 60, milliseconds % 1000 * 1000000);
    }

    public static LocalTime parseNanoTime(long nanoOfDay) {
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    public static int countSeconds(LocalTime time) {
        return Utils.countSeconds(time.getHour(), time.getMinute(), time.getSecond());
    }

    public static int countSeconds(int hour, int minute, int second) {
        return (hour * 60 + minute) * 60 + second;
    }

    public static LocalTime parseSecond(int seconds) {
        return LocalTime.of(seconds / 3600, seconds % 3600 / 60, seconds % 60);
    }

    public static int countMinutes(LocalTime time) {
        return Utils.countMinutes(time.getHour(), time.getMinute());
    }

    public static int countMinutes(int hour, int minute) {
        return hour * 60 + minute;
    }

    public static LocalTime parseMinute(int minutes) {
        return LocalTime.of(minutes / 60, minutes % 60);
    }
}

