/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BasicLongVector
extends AbstractVector {
    protected long[] values;

    public BasicLongVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicLongVector(List<Long> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i);
            }
        }
    }

    public BasicLongVector(long[] array) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = (long[])array.clone();
    }

    protected BasicLongVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new long[size];
    }

    protected BasicLongVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        ByteOrder bo;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new long[size];
        int totalBytes = size * 8;
        ByteOrder byteOrder = bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        for (int off = 0; off < totalBytes; off += len) {
            len = Math.min(4096, totalBytes - off);
            in.readFully(this.buf, 0, len);
            int start = off / 8;
            int end = len / 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                this.values[i + start] = byteBuffer.getLong(i * 8);
            }
        }
    }

    @Override
    public Scalar get(int index) {
        return new BasicLong(this.values[index]);
    }

    public long getLong(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, Scalar value) throws Exception {
        this.values[index] = value.isNull() ? Long.MIN_VALUE : value.getNumber().longValue();
    }

    public void setLong(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        long value = this.values[index];
        if (value >= 0L) {
            return (int)(value % (long)buckets);
        }
        if (value == Long.MIN_VALUE) {
            return -1;
        }
        return (int)((Long.MAX_VALUE % (long)buckets + 2L + (Long.MAX_VALUE + value) % (long)buckets) % (long)buckets);
    }

    @Override
    public Vector combine(Vector vector) {
        BasicLongVector v = (BasicLongVector)vector;
        int newSize = this.rows() + v.rows();
        long[] newValue = new long[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicLongVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index] == Long.MIN_VALUE;
    }

    @Override
    public void setNull(int index) {
        this.values[index] = Long.MIN_VALUE;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.INTEGRAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_LONG;
    }

    @Override
    public int rows() {
        return this.values.length;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicLong.class;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeLongArray(this.values);
    }
}

