/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.YearMonth;
import java.util.List;

public class BasicMonthVector
extends BasicIntVector {
    public BasicMonthVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicMonthVector(List<Integer> list) {
        super(list);
    }

    public BasicMonthVector(int[] array) {
        super(array);
    }

    protected BasicMonthVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicMonthVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MONTH;
    }

    @Override
    public Scalar get(int index) {
        return new BasicMonth(this.getInt(index));
    }

    public YearMonth getMonth(int index) {
        return Utils.parseMonth(this.getInt(index));
    }

    public void setMonth(int index, YearMonth month) {
        this.setInt(index, Utils.countMonths(month));
    }

    @Override
    public Class<?> getElementClass() {
        return YearMonth.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicMonthVector v = (BasicMonthVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicMonthVector(newValue);
    }
}

