/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLong;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicNanoTimestamp
extends BasicLong {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy.MM.dd'T'HH:mm:ss.SSSSSSSSS");

    public BasicNanoTimestamp(LocalDateTime value) {
        super(Utils.countNanoseconds(value));
    }

    public BasicNanoTimestamp(ExtendedDataInput in) throws IOException {
        super(in);
    }

    protected BasicNanoTimestamp(long value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_NANOTIMESTAMP;
    }

    public LocalDateTime getNanoTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseNanoTimestamp(this.getLong());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getNanoTimestamp();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getNanoTimestamp().format(format);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicNanoTimestamp) || o == null) {
            return false;
        }
        return this.getLong() == ((BasicNanoTimestamp)o).getLong();
    }
}

