/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class BasicTime
extends BasicInt {
    private static DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    public BasicTime(LocalTime value) {
        super(Utils.countMilliseconds(value));
    }

    public BasicTime(ExtendedDataInput in) throws IOException {
        super(in);
    }

    protected BasicTime(int value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIME;
    }

    public LocalTime getTime() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseTime(this.getInt());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getTime();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getTime().format(format);
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicTime) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicTime)o).getInt();
    }
}

