/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;

public interface Entity {
    public DATA_FORM getDataForm();

    public DATA_CATEGORY getDataCategory();

    public DATA_TYPE getDataType();

    public int rows();

    public int columns();

    public String getString();

    public void write(ExtendedDataOutput var1) throws IOException;

    public boolean isScalar();

    public boolean isVector();

    public boolean isPair();

    public boolean isTable();

    public boolean isMatrix();

    public boolean isDictionary();

    public boolean isChart();

    public boolean isChunk();

    public static DATA_CATEGORY typeToCategory(DATA_TYPE type) {
        if (type == DATA_TYPE.DT_TIME || type == DATA_TYPE.DT_SECOND || type == DATA_TYPE.DT_MINUTE || type == DATA_TYPE.DT_DATE || type == DATA_TYPE.DT_DATETIME || type == DATA_TYPE.DT_MONTH || type == DATA_TYPE.DT_TIMESTAMP || type == DATA_TYPE.DT_NANOTIME || type == DATA_TYPE.DT_NANOTIMESTAMP || type == DATA_TYPE.DT_DATEHOUR || type == DATA_TYPE.DT_DATEMINUTE) {
            return DATA_CATEGORY.TEMPORAL;
        }
        if (type == DATA_TYPE.DT_INT || type == DATA_TYPE.DT_LONG || type == DATA_TYPE.DT_SHORT || type == DATA_TYPE.DT_BYTE) {
            return DATA_CATEGORY.INTEGRAL;
        }
        if (type == DATA_TYPE.DT_BOOL) {
            return DATA_CATEGORY.LOGICAL;
        }
        if (type == DATA_TYPE.DT_DOUBLE || type == DATA_TYPE.DT_FLOAT) {
            return DATA_CATEGORY.FLOATING;
        }
        if (type == DATA_TYPE.DT_STRING || type == DATA_TYPE.DT_SYMBOL) {
            return DATA_CATEGORY.LITERAL;
        }
        if (type == DATA_TYPE.DT_INT128 || type == DATA_TYPE.DT_UUID || type == DATA_TYPE.DT_IPADDR) {
            return DATA_CATEGORY.BINARY;
        }
        if (type == DATA_TYPE.DT_ANY) {
            return DATA_CATEGORY.MIXED;
        }
        if (type == DATA_TYPE.DT_VOID) {
            return DATA_CATEGORY.NOTHING;
        }
        return DATA_CATEGORY.SYSTEM;
    }

    public static enum PARTITION_TYPE {
        SEQ,
        VALUE,
        RANGE,
        LIST,
        COMPO,
        HASH;

    }

    public static enum DATA_FORM {
        DF_SCALAR,
        DF_VECTOR,
        DF_PAIR,
        DF_MATRIX,
        DF_SET,
        DF_DICTIONARY,
        DF_TABLE,
        DF_CHART,
        DF_CHUNK;

    }

    public static enum DATA_CATEGORY {
        NOTHING,
        LOGICAL,
        INTEGRAL,
        FLOATING,
        TEMPORAL,
        LITERAL,
        SYSTEM,
        MIXED,
        BINARY;

    }

    public static enum DATA_TYPE {
        DT_VOID,
        DT_BOOL,
        DT_BYTE,
        DT_SHORT,
        DT_INT,
        DT_LONG,
        DT_DATE,
        DT_MONTH,
        DT_TIME,
        DT_MINUTE,
        DT_SECOND,
        DT_DATETIME,
        DT_TIMESTAMP,
        DT_NANOTIME,
        DT_NANOTIMESTAMP,
        DT_FLOAT,
        DT_DOUBLE,
        DT_SYMBOL,
        DT_STRING,
        DT_UUID,
        DT_FUNCTIONDEF,
        DT_HANDLE,
        DT_CODE,
        DT_DATASOURCE,
        DT_RESOURCE,
        DT_ANY,
        DT_COMPRESS,
        DT_DICTIONARY,
        DT_DATEHOUR,
        DT_DATEMINUTE,
        DT_IPADDR,
        DT_INT128,
        DT_BLOB,
        DT_OBJECT;

    }
}

