/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractScalar;
import com.xxdb.data.Entity;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.temporal.Temporal;

public class BasicFloat
extends AbstractScalar
implements Comparable<BasicFloat> {
    private static final DecimalFormat df1 = new DecimalFormat("0.######");
    private static final DecimalFormat df2 = new DecimalFormat("0.######E0");
    private float value;

    public BasicFloat(float value) {
        this.value = value;
    }

    public BasicFloat(ExtendedDataInput in) throws IOException {
        this.value = in.readFloat();
    }

    public float getFloat() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == -3.4028235E38f;
    }

    @Override
    public void setNull() {
        this.value = -3.4028235E38f;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.FLOATING;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_FLOAT;
    }

    @Override
    public Number getNumber() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    @Override
    public Temporal getTemporal() throws Exception {
        throw new Exception("Imcompatible data type");
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
            return String.valueOf(this.value);
        }
        float absVal = Math.abs(this.value);
        if (absVal > 0.0f && (double)absVal <= 1.0E-6 || (double)absVal >= 1000000.0) {
            return df2.format(this.value);
        }
        return df1.format(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicFloat) || o == null) {
            return false;
        }
        return this.value == ((BasicFloat)o).value;
    }

    public int hashCode() {
        return new Float(this.value).hashCode();
    }

    @Override
    protected void writeScalarToOutputStream(ExtendedDataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public int compareTo(BasicFloat o) {
        return Float.compare(this.value, o.value);
    }
}

