/*
 * Decompiled with CFR 0.152.
 */
package com.drixt.utils;

import com.drixt.utils.AssertException;
import java.util.Collection;
import java.util.Map;

public abstract class Assert {
    public static void isTrue(boolean condition, Object message, Object ... messageParams) {
        if (!condition) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isFalse(boolean condition, Object message, Object ... messageParams) {
        if (condition) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isNull(Object value, Object message, Object ... messageParams) {
        if (value != null) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isNotNull(Object value, Object message, Object ... messageParams) {
        if (value == null) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isEmpty(String value, Object message, Object ... messageParams) {
        if (value != null && !value.trim().isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isEmpty(Collection<?> value, Object message, Object ... messageParams) {
        if (value != null && !value.isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isEmpty(Map<?, ?> value, Object message, Object ... messageParams) {
        if (value != null && !value.isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static <V> void isEmpty(V[] value, Object message, Object ... messageParams) {
        if (value != null && value.length > 0) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isNotEmpty(String value, Object message, Object ... messageParams) {
        if (value == null || value.trim().isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isNotEmpty(Collection<?> value, Object message, Object ... messageParams) {
        Assert.isNotNull(value, message, messageParams);
        if (value.isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static void isNotEmpty(Map<?, ?> value, Object message, Object ... messageParams) {
        Assert.isNotNull(value, message, messageParams);
        if (value.isEmpty()) {
            throw new AssertException(message, messageParams);
        }
    }

    public static <V> void isNotEmpty(V[] value, Object message, Object ... messageParams) {
        Assert.isNotNull(value, message, messageParams);
        if (value.length == 0) {
            throw new AssertException(message, messageParams);
        }
    }
}

