/*
 * Decompiled with CFR 0.152.
 */
package com.drixt.utils;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18N
implements Serializable {
    public final List<Locale> supportedLocales;
    public final List<String> baseNames;

    public String getString(Object key, Object ... params) {
        return this.getString(null, (Object)(key instanceof Enum ? ((Enum)key).name() : key.toString()), params);
    }

    public String getString(Locale locale, Object key, Object ... params) {
        List<ResourceBundle> bundles = this.getBundles(locale);
        if (key == null) {
            throw new RuntimeException("I18N: Message key must not be null");
        }
        if (params != null && params.length > 0) {
            ArrayList<String> resolvedParams = new ArrayList<String>(params.length);
            for (Object param : params) {
                if (param == null) {
                    throw new RuntimeException("I18N: Message parameters must not be null. Current message key: " + String.valueOf(key));
                }
                resolvedParams.add(param instanceof Enum ? this.resolveKey(bundles, (Enum)param) : this.resolveKey(bundles, param.toString()));
            }
            return new MessageFormat(this.resolveKey(bundles, key.toString())).format(resolvedParams.toArray());
        }
        return this.resolveKey(bundles, key.toString());
    }

    private List<ResourceBundle> getBundles(Locale locale) {
        locale = this.resolveLocale(locale);
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (String bn : this.baseNames) {
            bundles.add(ResourceBundle.getBundle(bn, locale));
        }
        return bundles;
    }

    private Locale resolveLocale(Locale locale) {
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        return this.supportedLocales.contains(locale) ? locale : this.supportedLocales.get(0);
    }

    private String resolveKey(List<ResourceBundle> bundles, String key) {
        for (ResourceBundle bundle : bundles) {
            if (bundle.containsKey(key)) {
                return bundle.getString(key);
            }
            if (!bundle.containsKey(key.toUpperCase())) continue;
            return bundle.getString(key.toUpperCase());
        }
        return key;
    }

    private String resolveKey(List<ResourceBundle> bundles, Enum<?> key) {
        String resolvedString = null;
        for (ResourceBundle bundle : bundles) {
            if (!bundle.containsKey(key.name())) continue;
            resolvedString = bundle.getString(key.name());
            break;
        }
        if (StringUtils.isEmpty(resolvedString)) {
            resolvedString = this.resolveKey(bundles, key.toString());
        }
        return StringUtils.isNotEmpty(resolvedString) ? resolvedString : key.name();
    }

    public I18N(List<Locale> supportedLocales, List<String> baseNames) {
        this.supportedLocales = supportedLocales;
        this.baseNames = baseNames;
    }
}

