/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.column.function;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.ColumnArithmetic;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractColumFunction
implements ColumFunction,
ColumnArithmetic {
    protected final StringBuilder arithmeticSql = new StringBuilder();
    protected final ParameterBinder arithmeticParameterBinder = new ParameterBinder();
    protected Map<String, String> aliasTableMap;
    protected String dataSourceName;

    @Override
    public AbstractColumFunction subtract(Number value) {
        this.arithmeticSql.append(" - ").append(SqlUtils.registerValueWithKey(this.arithmeticParameterBinder, value));
        return this;
    }

    @Override
    public AbstractColumFunction subtract(Consumer<AbstractColumnReference> nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmeticSql.append(" - (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmeticParameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction subtract(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmeticSql.append(" - ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction multiply(Number value) {
        this.arithmeticSql.append(" * ").append(SqlUtils.registerValueWithKey(this.arithmeticParameterBinder, value));
        return this;
    }

    @Override
    public AbstractColumFunction multiply(Consumer<AbstractColumnReference> nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmeticSql.append(" * (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmeticParameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction multiply(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmeticSql.append(" * ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction divide(Number value) {
        this.arithmeticSql.append(" / ").append(SqlUtils.registerValueWithKey(this.arithmeticParameterBinder, value));
        return this;
    }

    @Override
    public AbstractColumFunction divide(Consumer<AbstractColumnReference> nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmeticSql.append(" / (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmeticParameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction divide(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmeticSql.append(" / ").append(name);
        return this;
    }

    @Override
    public AbstractColumFunction add(Number value) {
        this.arithmeticSql.append(" + ").append(SqlUtils.registerValueWithKey(this.arithmeticParameterBinder, value));
        return this;
    }

    @Override
    public AbstractColumFunction add(Consumer<AbstractColumnReference> nestedSelect) {
        SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.arithmeticSql.append(" + (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")");
        this.arithmeticParameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> AbstractColumFunction add(Fn<T, F> column) {
        String name = SqlUtils.extractQualifiedAlias(column, this.aliasTableMap, this.dataSourceName);
        this.arithmeticSql.append(" + ").append(name);
        return this;
    }

    public StringBuilder getArithmeticSql() {
        return this.arithmeticSql;
    }

    public ParameterBinder getArithmeticParameterBinder() {
        return this.arithmeticParameterBinder;
    }

    public Map<String, String> getAliasTableMap() {
        return this.aliasTableMap;
    }

    public void setAliasTableMap(Map<String, String> aliasTableMap) {
        if (aliasTableMap == null) {
            throw new IllegalStateException("Parameters must be set before calling: aliasTableMap");
        }
        this.aliasTableMap = aliasTableMap;
    }

    public String getDataSourceName() {
        if (this.dataSourceName == null) {
            throw new IllegalStateException("Parameters must be set before calling: dataSourceName");
        }
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

