/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.condition.impl.dialect;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.windows.aggregate.AggregateFunction;
import com.dynamic.sql.core.condition.Condition;
import com.dynamic.sql.core.condition.FunctionCondition;
import com.dynamic.sql.core.condition.NestedCondition;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.MysqlWhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.OracleWhereCondition;
import com.dynamic.sql.core.dml.select.HavingCondition;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class GenericWhereCondition
extends WhereCondition {
    protected final Version version;
    protected final Map<String, String> aliasTableMap;
    protected final StringBuilder condition = new StringBuilder();
    protected final ParameterBinder parameterBinder = new ParameterBinder();
    protected String dataSourceName;
    protected boolean isFirstBuild;

    public GenericWhereCondition(Version version, Map<String, String> aliasTableMap, String dataSourceName) {
        this.version = version;
        this.aliasTableMap = aliasTableMap;
        this.isFirstBuild = true;
        this.dataSourceName = dataSourceName;
    }

    @Override
    public <T, F> FunctionCondition andEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" = ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public FunctionCondition andEqualTo(Object value, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value)).append(" = ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" = ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public FunctionCondition orEqualTo(Object value, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value)).append(" = ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andNotEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" != ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orNotEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" != ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andGreaterThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" > ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orGreaterThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" > ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andGreaterThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" >= ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orGreaterThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" >= ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andLessThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" < ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orLessThan(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" < ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andLessThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" <= ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orLessThanOrEqualTo(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" <= ").append(columFunction.getFunctionToString(this.sqlDialect(), this.version));
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" in (").append(columFunction.getFunctionToString(this.sqlDialect(), this.version)).append(")");
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" in (").append(columFunction.getFunctionToString(this.sqlDialect(), this.version)).append(")");
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andNotIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" not in (").append(columFunction.getFunctionToString(this.sqlDialect(), this.version)).append(")");
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition orNotIn(Fn<T, F> fn, ColumFunction columFunction) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" not in (").append(columFunction.getFunctionToString(this.sqlDialect(), this.version)).append(")");
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> FunctionCondition andMatches(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> FunctionCondition orMatches(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> FunctionCondition andFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> FunctionCondition orFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        throw new UnsupportedOperationException();
    }

    private StringBuilder nestedSelectSql(Consumer<AbstractColumnReference> nestedSelect) {
        SqlStatementSelectWrapper sqlStatementSelectWrapper = SqlUtils.executeNestedSelect(nestedSelect);
        this.parameterBinder.addParameterBinder(sqlStatementSelectWrapper.getParameterBinder());
        return sqlStatementSelectWrapper.getRawSql();
    }

    @Override
    public <T, F> NestedCondition andEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" = (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" = (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andNotEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" != (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orNotEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" != (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andGreaterThan(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" > (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orGreaterThan(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" > (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andGreaterThanOrEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" >= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orGreaterThanOrEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" >= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andLessThan(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" < (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orLessThan(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" < (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andLessThanOrEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" <= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orLessThanOrEqualTo(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" <= (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andIn(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orIn(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition andNotIn(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public <T, F> NestedCondition orNotIn(Fn<T, F> fn, Consumer<AbstractColumnReference> nestedSelect) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public NestedCondition andExists(Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(SqlUtils.getSyntaxExists(this.matchSqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public NestedCondition orExists(Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(SqlUtils.getSyntaxExists(this.matchSqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public NestedCondition andNotExists(Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(" not ").append(SqlUtils.getSyntaxExists(this.matchSqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public NestedCondition orNotExists(Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(" not ").append(SqlUtils.getSyntaxExists(this.matchSqlDialect())).append(" (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public Condition andCondition(Consumer<Condition> nestedCondition) {
        return this.nestedCondition(nestedCondition, LogicalOperatorType.AND);
    }

    @Override
    public Condition orCondition(Consumer<Condition> nestedCondition) {
        return this.nestedCondition(nestedCondition, LogicalOperatorType.OR);
    }

    private Condition nestedCondition(Consumer<Condition> nestedCondition, LogicalOperatorType logicalOperatorType) {
        MysqlWhereCondition whereCondition = (MysqlWhereCondition)SqlUtils.matchDialectCondition(this.matchSqlDialect(), this.version, this.aliasTableMap, this.dataSourceName);
        nestedCondition.accept(whereCondition);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType)).append(" (").append(whereCondition.getWhereConditionSyntax()).append(") ");
        this.parameterBinder.addParameterBinder(whereCondition.getParameterBinder());
        return this;
    }

    @Override
    public <T, F> Condition andEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public Condition andEqualTo(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.getFunctionToString(this.sqlDialect(), this.version);
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(functionToString).append(" = ").append(key);
        return this;
    }

    @Override
    public <T1, T2, F> Condition andEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public <T, F> Condition orEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" = ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public <T, F> Condition andNotEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andNotEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public <T, F> Condition orNotEqualTo(Fn<T, F> fn, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orNotEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName)).append(" != ").append(SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName));
        return this;
    }

    @Override
    public <T, F> Condition andIsNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" is null");
        return this;
    }

    @Override
    public <T, F> Condition orIsNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" is null");
        return this;
    }

    @Override
    public <T, F> Condition andIsNotNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" is not null");
        return this;
    }

    @Override
    public <T, F> Condition orIsNotNull(Fn<T, F> fn) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(" is not null");
        return this;
    }

    @Override
    public <T, F> Condition andGreaterThan(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andGreaterThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" > ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition orGreaterThan(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orGreaterThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" > ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition andGreaterThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andGreaterThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" >= ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition orGreaterThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orGreaterThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" >= ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition andLessThan(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andLessThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition orLessThan(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orLessThan(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition andLessThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andLessThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(name).append(" <= ").append(name2);
        return this;
    }

    @Override
    public <T, F> Condition orLessThanOrEqualTo(Fn<T, F> fn, Object value) {
        String name = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orLessThanOrEqualTo(Fn<T1, F> field1, Fn<T2, F> field2) {
        String name = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String name2 = SqlUtils.extractQualifiedAlias(field2, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(name).append(" <= ").append(name2);
        return this;
    }

    private <T, F> void iteratingCollection(Fn<T, F> fn, Iterator<?> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("The parameter set cannot be empty");
        }
        this.condition.append(" (");
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, value));
            if (!iterator.hasNext()) continue;
            this.condition.append(", ");
        }
        this.condition.append(")");
    }

    @Override
    public <T, F> Condition andIn(Fn<T, F> fn, Iterable<?> values) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" in");
        this.iteratingCollection(fn, values.iterator());
        return this;
    }

    @Override
    public Condition andIn(Column column, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.getFunctionToString(this.sqlDialect(), this.version);
        this.condition.append(functionToString).append(" in");
        this.condition.append(" (");
        Iterator<?> iterator = values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.condition.append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
            if (!iterator.hasNext()) continue;
            this.condition.append(", ");
        }
        this.condition.append(")");
        return this;
    }

    @Override
    public <T, F> Condition orIn(Fn<T, F> fn, Iterable<?> values) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" in");
        this.iteratingCollection(fn, values.iterator());
        return this;
    }

    @Override
    public <T, F> Condition andNotIn(Fn<T, F> fn, Iterable<?> values) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not in");
        this.iteratingCollection(fn, values.iterator());
        return this;
    }

    @Override
    public <T, F> Condition orNotIn(Fn<T, F> fn, Iterable<?> values) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not in");
        this.iteratingCollection(fn, values.iterator());
        return this;
    }

    @Override
    public <T, F> Condition andBetween(Fn<T, F> fn, Object start, Object end) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end));
        return this;
    }

    @Override
    public <T1, T2, F> Condition andBetween(Fn<T1, F> field1, Fn<T2, F> startField, Fn<T2, F> endField) {
        String column = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String column2 = SqlUtils.extractQualifiedAlias(startField, this.aliasTableMap, this.dataSourceName);
        String column3 = SqlUtils.extractQualifiedAlias(endField, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" between ").append(column2).append(" and ").append(column3);
        return this;
    }

    @Override
    public <T, F> Condition orBetween(Fn<T, F> fn, Object start, Object end) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end));
        return this;
    }

    @Override
    public <T1, T2, F> Condition orBetween(Fn<T1, F> field1, Fn<T2, F> startField, Fn<T2, F> endField) {
        String column = SqlUtils.extractQualifiedAlias(field1, this.aliasTableMap, this.dataSourceName);
        String column2 = SqlUtils.extractQualifiedAlias(startField, this.aliasTableMap, this.dataSourceName);
        String column3 = SqlUtils.extractQualifiedAlias(endField, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" between ").append(column2).append(" and ").append(column3);
        return this;
    }

    @Override
    public <T, F> Condition andNotBetween(Fn<T, F> fn, Object start, Object end) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end));
        return this;
    }

    @Override
    public <T, F> Condition orNotBetween(Fn<T, F> fn, Object start, Object end) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, end));
        return this;
    }

    @Override
    public <T, F> Condition andLike(Fn<T, F> fn, String pattern) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern));
        return this;
    }

    @Override
    public <T, F> Condition orLike(Fn<T, F> fn, String pattern) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern));
        return this;
    }

    @Override
    public <T, F> Condition andNotLike(Fn<T, F> fn, String pattern) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(column).append(" not like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern));
        return this;
    }

    @Override
    public <T, F> Condition orNotLike(Fn<T, F> fn, String pattern) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(column).append(" not like ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, pattern));
        return this;
    }

    @Override
    public <T, F> Condition andMatches(Fn<T, F> fn, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> Condition orMatches(Fn<T, F> fn, String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> Condition andFindInSet(Fn<T, F> fn, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> Condition orFindInSet(Fn<T, F> fn, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> Condition andFindInSet(Fn<T, F> fn, Object item, String separator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, F> Condition orFindInSet(Fn<T, F> fn, Object item, String separator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition limit(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Condition limit(int limit) {
        throw new UnsupportedOperationException();
    }

    public String getWhereConditionSyntax() {
        return this.condition.toString();
    }

    public ParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }

    protected String logicalOperatorType(LogicalOperatorType logicalOperatorType) {
        return this.logicalOperatorType(logicalOperatorType, this.matchSqlDialect());
    }

    protected String logicalOperatorType(LogicalOperatorType logicalOperatorType, SqlDialect sqlDialect) {
        if (this.isFirstBuild) {
            this.isFirstBuild = false;
            return "";
        }
        return SqlUtils.getSyntaxLogicalOperator(logicalOperatorType, sqlDialect) + " ";
    }

    @Override
    public HavingCondition andEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" = ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andNotEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andNotEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orNotEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orNotEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" != ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andGreaterThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andGreaterThan(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orGreaterThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orGreaterThan(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" > ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andGreaterThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andGreaterThanOrEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orGreaterThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orGreaterThanOrEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" >= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andLessThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andLessThan(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orLessThan(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orLessThan(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" < ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andLessThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition andLessThanOrEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition orLessThanOrEqualTo(AggregateFunction function, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append(SqlUtils.registerValueWithKey(this.parameterBinder, value));
        return this;
    }

    @Override
    public HavingCondition orLessThanOrEqualTo(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" ").append(this.executeFunctionToString(function)).append(" <= ").append((CharSequence)this.nestedSelectSql(nestedSelect));
        return this;
    }

    @Override
    public HavingCondition andIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" in");
        this.iteratingCollection(null, values.iterator());
        return this;
    }

    @Override
    public HavingCondition andIn(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public HavingCondition orIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" in");
        this.iteratingCollection(null, values.iterator());
        return this;
    }

    @Override
    public HavingCondition orIn(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public HavingCondition andNotIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not in");
        this.iteratingCollection(null, values.iterator());
        return this;
    }

    @Override
    public HavingCondition andNotIn(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public HavingCondition orNotIn(AggregateFunction function, Iterable<?> values) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not in");
        this.iteratingCollection(null, values.iterator());
        return this;
    }

    @Override
    public HavingCondition orNotIn(AggregateFunction function, Consumer<AbstractColumnReference> nestedSelect) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not in (").append((CharSequence)this.nestedSelectSql(nestedSelect)).append(")");
        return this;
    }

    @Override
    public HavingCondition andBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public HavingCondition orBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public HavingCondition andNotBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND)).append(this.executeFunctionToString(function)).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    @Override
    public HavingCondition orNotBetween(AggregateFunction function, Object start, Object end) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR)).append(this.executeFunctionToString(function)).append(" not between ").append(SqlUtils.registerValueWithKey(this.parameterBinder, start)).append(" and ").append(SqlUtils.registerValueWithKey(this.parameterBinder, end));
        return this;
    }

    protected String executeFunctionToString(AggregateFunction function) {
        return function.getFunctionToString(this.matchSqlDialect(), this.version);
    }

    private SqlDialect matchSqlDialect() {
        if (this instanceof MysqlWhereCondition) {
            return SqlDialect.MYSQL;
        }
        if (this instanceof OracleWhereCondition) {
            return SqlDialect.ORACLE;
        }
        return SqlDialect.MYSQL;
    }

    protected SqlDialect sqlDialect() {
        throw new UnsupportedOperationException("Unimplemented SQL dialects");
    }
}

