/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.condition.impl.dialect;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.condition.Condition;
import com.dynamic.sql.core.condition.FunctionCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Map;

public class MysqlWhereCondition
extends GenericWhereCondition {
    public MysqlWhereCondition(Version version, Map<String, String> aliasTableMap, String dataSourceName) {
        super(version, aliasTableMap, dataSourceName);
    }

    @Override
    protected SqlDialect sqlDialect() {
        return SqlDialect.MYSQL;
    }

    @Override
    public <T, F> Condition andMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.AND, fn, regex);
    }

    @Override
    public <T, F> Condition orMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.OR, fn, regex);
    }

    public <T, F> Condition matches(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, String regex) {
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType));
        if (this.version.isGreaterThanOrEqual(new Version(8, 0, 0))) {
            this.condition.append(" regexp_like(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, regex)).append(")");
            return this;
        }
        this.condition.append(" ").append(column).append(" regexp ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, regex));
        return this;
    }

    @Override
    public <T, F> FunctionCondition andMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.AND, fn, columFunction);
    }

    @Override
    public <T, F> FunctionCondition orMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.OR, fn, columFunction);
    }

    public <T, F> FunctionCondition matchesFunction(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType));
        if (this.version.isGreaterThanOrEqual(new Version(8, 0, 0))) {
            this.condition.append(" regexp_like(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version))).append(")");
            return this;
        }
        this.condition.append(" ").append(column).append(" regexp ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version)));
        return this;
    }

    @Override
    public <T, F> Condition andFindInSet(Fn<T, F> fn, Object item) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public <T, F> Condition andFindInSet(Fn<T, F> fn, Object item, String separator) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append("replace(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, separator)).append(", ',')").append(")");
        return this;
    }

    @Override
    public <T, F> Condition orFindInSet(Fn<T, F> fn, Object item) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public <T, F> Condition orFindInSet(Fn<T, F> fn, Object item, String separator) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String column = SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName);
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append("replace(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, separator)).append(", ',')").append(")");
        return this;
    }

    @Override
    public <T, F> FunctionCondition andFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version))).append(", ").append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public <T, F> FunctionCondition orFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version))).append(", ").append(SqlUtils.extractQualifiedAlias(fn, this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public Condition limit(int limit) {
        return this.limit(0, limit);
    }

    @Override
    public Condition limit(int offset, int limit) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" limit ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, offset)).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, limit));
        return this;
    }
}

