/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.database;

import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.enums.DMLType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDebugger {
    private static final Logger log = LoggerFactory.getLogger(SqlDebugger.class);

    private SqlDebugger() {
    }

    public static void debug(SchemaProperties.PrintSqlProperties printSqlProperties, PreparedSql preparedSql, String dataSourceName, boolean isIntercepted) {
        if (!log.isDebugEnabled() || !printSqlProperties.isPrintSql()) {
            return;
        }
        if (!printSqlProperties.isPrintDataSourceName()) {
            dataSourceName = "";
        }
        log.debug("{} -->     Preparing: {}", (Object)dataSourceName, (Object)preparedSql.getSql());
        List<List<Object>> batchParams = preparedSql.getBatchParams();
        for (List<Object> batchParam : batchParams) {
            log.debug("{} -->    Parameters: {}", (Object)dataSourceName, (Object)SqlDebugger.assemblyParameters(batchParam));
        }
        if (!isIntercepted) {
            log.debug("{} -->       !!!!!! : SQL is intercepted.", (Object)dataSourceName);
        }
    }

    public static void debug(SchemaProperties.PrintSqlProperties printSqlProperties, DMLType dmlType, String dataSourceName, Object applyResult) {
        if (!log.isDebugEnabled() || !printSqlProperties.isPrintSql()) {
            return;
        }
        if (!printSqlProperties.isPrintDataSourceName()) {
            dataSourceName = "";
        }
        if (dmlType == DMLType.SELECT) {
            if (applyResult instanceof Collection) {
                Map map;
                Map.Entry entry;
                Object next;
                Collection collection = (Collection)applyResult;
                if (collection.size() == 1 && (next = collection.iterator().next()) instanceof Map && ((String)(entry = (map = (Map)next).entrySet().iterator().next()).getKey()).equalsIgnoreCase("count(1)")) {
                    log.debug("{} <--         Count: {}", (Object)dataSourceName, entry.getValue());
                    return;
                }
                log.debug("{} <--         Total: {}", (Object)dataSourceName, (Object)collection.size());
            } else {
                log.debug("{} <--     Returned: {}", (Object)dataSourceName, applyResult);
            }
        }
        if (dmlType == DMLType.INSERT || dmlType == DMLType.UPDATE || dmlType == DMLType.DELETE) {
            log.debug("{} <-- Affected Rows: {}", (Object)dataSourceName, applyResult);
        }
    }

    private static StringBuilder assemblyParameters(List<Object> params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            stringBuilder.append(param);
            if (param != null) {
                stringBuilder.append("(").append(param.getClass().getSimpleName()).append(")");
            }
            if (i == params.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }
}

