/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.database;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.database.AbstractSqlExecutor;
import com.dynamic.sql.core.database.PreparedSql;
import com.dynamic.sql.core.database.SqlDebugger;
import com.dynamic.sql.core.database.SqlExecutor;
import com.dynamic.sql.core.database.impl.MysqlSqlExecutor;
import com.dynamic.sql.core.database.impl.OracleSqlExecutor;
import com.dynamic.sql.core.database.parser.AbstractDialectParser;
import com.dynamic.sql.core.database.parser.dialect.MysqlParser;
import com.dynamic.sql.core.database.parser.dialect.OracleParser;
import com.dynamic.sql.core.dml.SqlStatementWrapper;
import com.dynamic.sql.datasource.DataSourceMeta;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.datasource.connection.ConnectionHolder;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.interceptor.ExecutionControl;
import com.dynamic.sql.interceptor.SqlInterceptorChain;
import com.dynamic.sql.utils.SqlUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.function.Function;

public class SqlExecutionFactory {
    private SqlExecutionFactory() {
    }

    public static AbstractDialectParser chosenDialectParser(SchemaProperties schemaProperties, Class<?> entityClass, Collection<Object> param) {
        return SqlExecutionFactory.chosenDialectParser(schemaProperties, entityClass, param, null);
    }

    public static AbstractDialectParser chosenDialectParser(SchemaProperties schemaProperties, Class<?> entityClass, Collection<Object> param, WhereCondition whereCondition) {
        SqlDialect sqlDialect = schemaProperties.getSqlDialect();
        switch (sqlDialect) {
            case MYSQL: 
            case MARIADB: {
                return new MysqlParser(entityClass, schemaProperties, param, whereCondition);
            }
            case ORACLE: {
                return new OracleParser(entityClass, schemaProperties, param, whereCondition);
            }
        }
        throw new UnsupportedOperationException("Unsupported dialect: " + (Object)((Object)sqlDialect));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R executorSql(DMLType dmlType, SqlStatementWrapper sqlStatementWrapper, Function<SqlExecutor, R> doSqlExecutor) {
        String dataSourceName = sqlStatementWrapper.getDataSourceName();
        SqlInterceptorChain sqlInterceptorChain = SqlInterceptorChain.getInstance();
        DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(dataSourceName);
        Connection connection = null;
        Exception exception = null;
        R apply = null;
        PreparedSql preparedSql = null;
        try {
            connection = ConnectionHolder.getConnection(dataSourceMeta.getDataSource());
            ExecutionControl executionControl = sqlInterceptorChain.beforeExecution(sqlStatementWrapper, connection);
            preparedSql = SqlUtils.parsePreparedObject(sqlStatementWrapper);
            apply = executionControl == ExecutionControl.PROCEED ? (R)SqlExecutionFactory.applySql(dmlType, dataSourceName, connection, preparedSql, true, doSqlExecutor) : (R)sqlInterceptorChain.retrieveSkippedResult(sqlStatementWrapper, connection);
        }
        catch (Exception e) {
            try {
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    ConnectionHolder.releaseConnection(dataSourceMeta.getDataSource(), connection);
                    sqlInterceptorChain.afterExecution(preparedSql, apply, exception);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    sqlInterceptorChain.afterExecution(preparedSql, apply, exception);
                    throw throwable2;
                }
            }
        }
        try {
            ConnectionHolder.releaseConnection(dataSourceMeta.getDataSource(), connection);
            return apply;
        }
        finally {
            sqlInterceptorChain.afterExecution(preparedSql, apply, exception);
        }
    }

    public static <R> R applySql(DMLType dmlType, String dataSourceName, Connection connection, PreparedSql preparedSql, boolean isIntercepted, Function<SqlExecutor, R> doSqlExecutor) {
        AbstractSqlExecutor sqlExecutor;
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName);
        switch (schemaProperties.getSqlDialect()) {
            case MYSQL: {
                sqlExecutor = new MysqlSqlExecutor(connection, preparedSql);
                break;
            }
            case ORACLE: {
                sqlExecutor = new OracleSqlExecutor(connection, preparedSql);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported sql dialect" + (Object)((Object)schemaProperties.getSqlDialect()));
            }
        }
        SchemaProperties.PrintSqlProperties printSqlProperties = schemaProperties.getPrintSqlProperties();
        SqlDebugger.debug(printSqlProperties, preparedSql, dataSourceName, isIntercepted);
        R applyResult = doSqlExecutor.apply(sqlExecutor);
        SqlDebugger.debug(printSqlProperties, dmlType, dataSourceName, applyResult);
        return applyResult;
    }
}

