/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.dml.select.AbstractFetchResult;
import com.dynamic.sql.plugins.conversion.AttributeConverter;
import com.dynamic.sql.plugins.conversion.FetchResultConverter;
import com.dynamic.sql.table.FieldMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.table.TableUtils;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.ConverterUtils;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FetchResultImpl<R>
extends AbstractFetchResult<R> {
    private final Class<R> resultClass;
    private final HashSet<String> notUsedColumnTips = new HashSet();

    public FetchResultImpl(Class<R> returnClass, List<Map<String, Object>> wrapperList) {
        super(wrapperList);
        this.resultClass = returnClass;
    }

    @Override
    public R toOne() {
        Collection<R> rs = this.convertToCollection(ArrayList::new);
        if (rs.isEmpty()) {
            return null;
        }
        if (rs.size() > 1) {
            throw new IllegalStateException("Expected one result, but found: " + rs.size());
        }
        return rs.iterator().next();
    }

    @Override
    public <L extends List<R>> L toList(Supplier<L> listSupplier) {
        return (L)((List)this.convertToCollection(listSupplier));
    }

    @Override
    public <S extends Set<R>> S toSet(Supplier<S> setSupplier) {
        return (S)((Set)this.convertToCollection(setSupplier));
    }

    @Override
    public <K, V, M extends Map<K, V>> Map<K, V> toMap(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return this.convertToMap(keyMapper, valueMapper, mergeFunction, mapSupplier);
    }

    @Override
    public <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> toGroupingBy(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, Supplier<C> collectionSupplier, Supplier<M> mapSupplier) {
        return this.convertToGroupingBy(keyMapper, valueMapper, collectionSupplier, mapSupplier);
    }

    private Collection<R> convertToCollection(Supplier<? extends Collection<R>> listSupplier) {
        Collection<R> collection = listSupplier.get();
        if (CollectionUtils.isEmpty(this.wrapperList)) {
            return collection;
        }
        FetchResultConverter<R> fetchResultConverter = ConverterUtils.getFetchResultConverter(this.resultClass);
        if (fetchResultConverter != null) {
            for (Map stringObjectMap : this.wrapperList) {
                collection.add(fetchResultConverter.convertValueTo(stringObjectMap));
            }
            return collection;
        }
        if (this.resultClass == Object.class || Map.class.isAssignableFrom(this.resultClass) || Collection.class.isAssignableFrom(this.resultClass)) {
            return this.wrapperList;
        }
        if (this.resultClass.getClassLoader() == null) {
            return this.convertToSystemClass(collection);
        }
        List<FieldMeta> fieldMetas = this.getFieldMetas("Collection");
        Map<String, FieldMeta> columnNameMap = fieldMetas.stream().collect(Collectors.toMap(FieldMeta::getColumnName, v -> v));
        Map<String, FieldMeta> fieldNameMap = fieldMetas.stream().collect(Collectors.toMap(k -> k.getField().getName(), v -> v));
        for (Map columnObjectMap : this.wrapperList) {
            collection.add(this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap));
        }
        return collection;
    }

    private <T, K, V, M extends Map<K, V>> Map<K, V> convertToMap(Function<T, ? extends K> keyMapper, Function<T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        return this.convertTo(mapSupplier, (m, columnObjectMap, columnNameMap, fieldNameMap) -> {
            R value = this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap);
            Object key = keyMapper.apply(value);
            Object val = valueMapper.apply(value);
            m.merge(key, val, mergeFunction);
        });
    }

    public <K, V, C extends Collection<V>, M extends Map<K, C>> Map<K, C> convertToGroupingBy(Function<R, ? extends K> keyMapper, Function<R, ? extends V> valueMapper, Supplier<C> collectionSupplier, Supplier<M> mapSupplier) {
        return this.convertTo(mapSupplier, (m, columnObjectMap, columnNameMap, fieldNameMap) -> {
            R result = this.reflectionInstance(columnObjectMap, columnNameMap, fieldNameMap);
            Object key = keyMapper.apply(result);
            Object value = valueMapper.apply(result);
            Collection groupedCollection = (Collection)m.computeIfAbsent(key, arg_0 -> FetchResultImpl.lambda$null$4((Supplier)collectionSupplier, arg_0));
            groupedCollection.add(value);
        });
    }

    private Collection<R> convertToSystemClass(Collection<R> collection) {
        for (Map stringObjectMap : this.wrapperList) {
            if (stringObjectMap.size() > 1) {
                throw new IllegalArgumentException("Multiple columns were queried: " + StringUtils.join((CharSequence)", ", stringObjectMap.keySet()));
            }
            if (stringObjectMap.isEmpty()) {
                collection.add(null);
            }
            Map.Entry entry = stringObjectMap.entrySet().iterator().next();
            R value = ConverterUtils.convertToEntityAttribute(this.resultClass, entry.getValue());
            collection.add(value);
        }
        return collection;
    }

    private FieldMeta getColumnMeta(String columnName, Map<String, FieldMeta> columnNameMap, Map<String, FieldMeta> fieldNameMap) {
        FieldMeta columnMeta = columnNameMap.get(columnName);
        if (columnMeta == null) {
            columnMeta = fieldNameMap.get(columnName);
        }
        if (columnMeta == null && log.isTraceEnabled() && !this.notUsedColumnTips.contains(columnName)) {
            log.trace("Column '{}' was queried but not used.", (Object)columnName);
            this.notUsedColumnTips.add(columnName);
        }
        return columnMeta;
    }

    R reflectionInstance(Map<String, Object> columnObjectMap, Map<String, FieldMeta> columnNameMap, Map<String, FieldMeta> fieldNameMap) {
        R instance = ReflectUtils.instance(this.resultClass, new Object[0]);
        columnObjectMap.forEach((columnName, columnValue) -> {
            Object value;
            FieldMeta columnMeta = this.getColumnMeta((String)columnName, columnNameMap, fieldNameMap);
            if (columnMeta == null) {
                return;
            }
            if (null != columnMeta.getConverter()) {
                AttributeConverter<Object, Object> objectObjectAttributeConverter = ConverterUtils.loadCustomConverter(columnMeta.getConverter());
                value = objectObjectAttributeConverter.convertToEntityAttribute(columnValue);
            } else {
                value = ConverterUtils.convertToEntityAttribute(columnMeta.getField().getType(), columnValue);
            }
            if (value != null) {
                ReflectUtils.setFieldValue(instance, columnMeta.getField(), value);
            }
        });
        return instance;
    }

    private <K, V, M extends Map<K, V>> Map<K, V> convertTo(Supplier<M> mapSupplier, Operator operator) {
        Map m = (Map)mapSupplier.get();
        if (CollectionUtils.isEmpty(this.wrapperList)) {
            return m;
        }
        List<FieldMeta> fieldMetas = this.getFieldMetas("Map");
        Map<String, FieldMeta> columnNameMap = fieldMetas.stream().collect(Collectors.toMap(FieldMeta::getColumnName, v -> v));
        Map<String, FieldMeta> fieldNameMap = fieldMetas.stream().collect(Collectors.toMap(k -> k.getField().getName(), v -> v));
        for (Map columnObjectMap : this.wrapperList) {
            operator.apply(m, columnObjectMap, columnNameMap, fieldNameMap);
        }
        return m;
    }

    private List<FieldMeta> getFieldMetas(String converterTips) {
        List<FieldMeta> fieldMetas;
        TableMeta tableMeta = TableProvider.getTableMeta(this.resultClass);
        if (tableMeta == null) {
            if (this.resultClass.getClassLoader() == null) {
                throw new IllegalStateException(this.resultClass.getCanonicalName() + " cannot be mapped to " + converterTips);
            }
            fieldMetas = TableUtils.parseViewClass(this.resultClass).getViewColumnMetas();
        } else {
            fieldMetas = tableMeta.getColumnMetas();
        }
        return fieldMetas;
    }

    private static /* synthetic */ Object lambda$null$4(Supplier collectionSupplier, Object k) {
        return (Collection)collectionSupplier.get();
    }

    static interface Operator {
        public void apply(Map var1, Map<String, Object> var2, Map<String, FieldMeta> var3, Map<String, FieldMeta> var4);
    }
}

