/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.database.SqlExecutionFactory;
import com.dynamic.sql.core.dml.select.FetchResult;
import com.dynamic.sql.core.dml.select.FetchResultImpl;
import com.dynamic.sql.core.dml.select.Fetchable;
import com.dynamic.sql.core.dml.select.SelectHandler;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.enums.DMLType;
import com.dynamic.sql.utils.SqlUtils;
import java.util.List;

public class FetchableImpl
implements Fetchable {
    private SqlStatementSelectWrapper sqlStatementSelectWrapper;

    public FetchableImpl(SelectSpecification selectSpecification) {
        SqlSelectBuilder sqlSelectBuilder = SqlUtils.matchSqlSelectBuilder(selectSpecification);
        this.sqlStatementSelectWrapper = sqlSelectBuilder.build();
    }

    @Override
    public <R> FetchResult<R> fetch() {
        return this.fetchResult(null);
    }

    @Override
    public <T> FetchResult<T> fetch(Class<T> returnClass) {
        return this.fetchResult(returnClass);
    }

    private <T> FetchResult<T> fetchResult(Class<T> returnClass) {
        if (returnClass == null) {
            if (this.sqlStatementSelectWrapper.getGuessTheTargetClass() == null) {
                throw new IllegalStateException("The query result object cannot be inferred from the context. Please declare the return type.");
            }
            returnClass = this.sqlStatementSelectWrapper.getGuessTheTargetClass();
        }
        List wrapperList = SqlExecutionFactory.executorSql(DMLType.SELECT, this.sqlStatementSelectWrapper, SelectHandler::executeQuery);
        return new FetchResultImpl<T>(returnClass, wrapperList);
    }
}

