/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.FieldFn;
import com.dynamic.sql.core.GroupFn;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.condition.Condition;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.dml.select.FetchResult;
import com.dynamic.sql.core.dml.select.Fetchable;
import com.dynamic.sql.core.dml.select.FetchableImpl;
import com.dynamic.sql.core.dml.select.HavingCondition;
import com.dynamic.sql.core.dml.select.JoinCondition;
import com.dynamic.sql.core.dml.select.ThenSortOrder;
import com.dynamic.sql.core.dml.select.build.LimitInfo;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.join.CrossJoin;
import com.dynamic.sql.core.dml.select.build.join.FullJoin;
import com.dynamic.sql.core.dml.select.build.join.InnerJoin;
import com.dynamic.sql.core.dml.select.build.join.LeftJoin;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.RightJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.dml.select.cte.CteTable;
import com.dynamic.sql.core.dml.select.order.CustomOrderBy;
import com.dynamic.sql.core.dml.select.order.DefaultOrderBy;
import com.dynamic.sql.enums.JoinTableType;
import com.dynamic.sql.enums.SortOrder;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TableRelation<R>
implements JoinCondition {
    private final SelectSpecification selectSpecification;

    public TableRelation(SelectSpecification selectSpecification) {
        this.selectSpecification = selectSpecification;
    }

    @Override
    public JoinCondition innerJoin(Class<?> clazz, Consumer<Condition> onCondition) {
        return this.innerJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition innerJoin(Class<?> clazz, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new InnerJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoin(Consumer<AbstractColumnReference> nestedSelect, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.INNER, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new TableFunctionJoin(JoinTableType.INNER, tableFunction, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition innerJoin(CteTable cte, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition leftJoin(Class<?> clazz, Consumer<Condition> onCondition) {
        return this.leftJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition leftJoin(Class<?> clazz, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new LeftJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition leftJoin(Consumer<AbstractColumnReference> nestedSelect, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.LEFT, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition leftJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition leftJoin(CteTable cte, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition rightJoin(Class<?> clazz, Consumer<Condition> onCondition) {
        return this.rightJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition rightJoin(Class<?> clazz, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new RightJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition rightJoin(Consumer<AbstractColumnReference> nestedSelect, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new NestedJoin(JoinTableType.RIGHT, nestedSelect, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition rightJoin(Supplier<TableFunction> tableFunction, String alias, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition rightJoin(CteTable cte, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition fullJoin(Class<?> clazz, Consumer<Condition> onCondition) {
        return this.fullJoin(clazz, null, onCondition);
    }

    @Override
    public JoinCondition fullJoin(Class<?> clazz, String alias, Consumer<Condition> onCondition) {
        this.selectSpecification.getJoinTables().add(new FullJoin(clazz, alias, onCondition));
        return this;
    }

    @Override
    public JoinCondition fullJoin(CteTable cte, Consumer<Condition> onCondition) {
        throw new UnsupportedOperationException("Not yet implemented, to be improved later");
    }

    @Override
    public JoinCondition crossJoin(Class<?> clazz) {
        this.selectSpecification.getJoinTables().add(new CrossJoin(clazz));
        return this;
    }

    @Override
    public JoinCondition crossJoin(CteTable cte) {
        this.selectSpecification.getJoinTables().add(new CrossJoin(cte));
        return this;
    }

    public TableRelation<R> where(Consumer<WhereCondition> condition) {
        this.selectSpecification.setWhereCondition(condition);
        return this;
    }

    @Override
    public Fetchable limit(int offset, int limit) {
        this.selectSpecification.setLimitInfo(new LimitInfo(offset, limit));
        return this;
    }

    @Override
    public Fetchable limit(int limit) {
        this.selectSpecification.setLimitInfo(new LimitInfo(null, limit));
        return this;
    }

    public TableRelation<R> where() {
        return this;
    }

    @Override
    public FetchResult<R> fetch() {
        FetchableImpl fetchable = new FetchableImpl(this.selectSpecification);
        return fetchable.fetch();
    }

    @Override
    public <T> FetchResult<T> fetch(Class<T> returnClass) {
        FetchableImpl fetchable = new FetchableImpl(this.selectSpecification);
        return fetchable.fetch(returnClass);
    }

    @SafeVarargs
    public final <T> TableRelation<R> groupBy(FieldFn<T, ?> ... fnKey) {
        if (fnKey == null) {
            return this;
        }
        for (FieldFn<T, ?> tkFn : fnKey) {
            this.selectSpecification.getGroupByFields().add(tkFn);
        }
        return this;
    }

    public final TableRelation<R> groupBy(String tableAlias, String columnName) {
        this.selectSpecification.getGroupByFields().add(new GroupFn(tableAlias, columnName));
        return this;
    }

    public final <T> TableRelation<R> groupBy(String tableAlias, FieldFn<T, ?> fn) {
        this.selectSpecification.getGroupByFields().add(new GroupFn(tableAlias, fn));
        return this;
    }

    public final TableRelation<R> groupBy(GroupFn ... groupByFn) {
        this.selectSpecification.getGroupByFields().addAll(Arrays.asList(groupByFn));
        return this;
    }

    public TableRelation<R> having(Consumer<HavingCondition> condition) {
        this.selectSpecification.setHavingCondition(condition);
        return this;
    }

    public <T, F> ThenSortOrder<R> orderBy(FieldFn<T, F> field) {
        return this.orderBy(field, SortOrder.ASC);
    }

    public <T, F> ThenSortOrder<R> orderBy(FieldFn<T, F> field, SortOrder sortOrder) {
        return new ThenSortOrder(this, new DefaultOrderBy(field, sortOrder));
    }

    public <T, F> ThenSortOrder<R> orderBy(String tableAlias, FieldFn<T, F> field) {
        return new ThenSortOrder(this, new DefaultOrderBy(tableAlias, field, SortOrder.ASC));
    }

    public <T, F> ThenSortOrder<R> orderBy(String tableAlias, FieldFn<T, F> field, SortOrder sortOrder) {
        return new ThenSortOrder(this, new DefaultOrderBy(tableAlias, field, sortOrder));
    }

    public ThenSortOrder<R> orderBy(String tableAlias, String columnName) {
        return this.orderBy(tableAlias, columnName, SortOrder.ASC);
    }

    public ThenSortOrder<R> orderBy(String tableAlias, String columnName, SortOrder sortOrder) {
        return new ThenSortOrder(this, new DefaultOrderBy(tableAlias, columnName, sortOrder));
    }

    public ThenSortOrder<R> orderBy(String orderingFragment) {
        return new ThenSortOrder(this, new CustomOrderBy(orderingFragment));
    }

    protected SelectSpecification getSelectSpecification() {
        return this.selectSpecification;
    }
}

