/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select.build;

import com.dynamic.sql.core.AbstractColumnReference;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.column.AbstractAliasHelper;
import com.dynamic.sql.core.column.ColumnModifiers;
import com.dynamic.sql.core.column.conventional.AllColumn;
import com.dynamic.sql.core.column.conventional.NumberColumn;
import com.dynamic.sql.core.column.function.AbstractColumFunction;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.column.function.TableFunction;
import com.dynamic.sql.core.column.function.windows.Over;
import com.dynamic.sql.core.column.function.windows.aggregate.Count;
import com.dynamic.sql.core.condition.Condition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.select.build.LimitInfo;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlSelectBuilder;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.column.ColumnQuery;
import com.dynamic.sql.core.dml.select.build.column.FunctionColumn;
import com.dynamic.sql.core.dml.select.build.column.NestedColumn;
import com.dynamic.sql.core.dml.select.build.join.FromJoin;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.table.ColumnMeta;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.ReflectUtils;
import com.dynamic.sql.utils.SqlUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class GenericSqlSelectBuilder
extends SqlSelectBuilder {
    public GenericSqlSelectBuilder(SelectSpecification selectSpecification) {
        super(selectSpecification);
    }

    @Override
    protected void parseColumnFunction() {
        this.sqlBuilder.append(SqlUtils.getSyntaxSelect(this.sqlDialect)).append(" ");
        for (int i = 0; i < this.selectSpecification.getColumFunctions().size(); ++i) {
            ColumnQuery columnQuery = this.selectSpecification.getColumFunctions().get(i);
            String columnSeparator = ", ";
            if (this.selectSpecification.getColumFunctions().size() - 1 == i) {
                columnSeparator = "";
            }
            if (columnQuery instanceof FunctionColumn) {
                StringBuilder arithmeticSql;
                FunctionColumn functionColumn = (FunctionColumn)columnQuery;
                ColumFunction columFunction = functionColumn.getColumFunction();
                if (columFunction instanceof AllColumn) {
                    this.parseAllColumn((AllColumn)columFunction);
                    this.sqlBuilder.append(columnSeparator);
                    continue;
                }
                ParameterBinder arithmeticParameterBinder = null;
                if (columFunction instanceof AbstractColumFunction) {
                    AbstractColumFunction abstractColumFunction = (AbstractColumFunction)columFunction;
                    abstractColumFunction.setAliasTableMap(this.aliasTableMap);
                    abstractColumFunction.setDataSourceName(this.dataSourceName);
                    arithmeticSql = abstractColumFunction.getArithmeticSql();
                    arithmeticParameterBinder = abstractColumFunction.getArithmeticParameterBinder();
                } else {
                    arithmeticSql = new StringBuilder();
                }
                if (columFunction instanceof NumberColumn || columFunction instanceof Count) {
                    this.sqlBuilder.append(columFunction.getFunctionToString(this.sqlDialect, this.version)).append((CharSequence)arithmeticSql);
                    this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
                    String columnAlias = StringUtils.isEmpty(columnQuery.getAlias()) ? "" : this.syntaxAs() + columnQuery.getAlias();
                    this.sqlBuilder.append(this.syntaxColumnAlias(columnAlias)).append(columnSeparator);
                    continue;
                }
                Fn<?, ?> fn = columFunction.getOriginColumnFn();
                if (columFunction instanceof AbstractAliasHelper) {
                    this.sqlBuilder.append(columFunction.getFunctionToString(this.sqlDialect, this.version)).append((CharSequence)arithmeticSql);
                    this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
                    if (StringUtils.isNotBlank(columnQuery.getAlias())) {
                        this.sqlBuilder.append(this.syntaxAs()).append(columnQuery.getAlias());
                    }
                    this.sqlBuilder.append(columnSeparator);
                    continue;
                }
                String tableAlias = columFunction.getTableAlias();
                if (tableAlias == null) {
                    tableAlias = (String)this.aliasTableMap.get(ReflectUtils.getOriginalClassCanonicalName(fn));
                }
                columFunction.setTableAlias(tableAlias);
                String functionToString = columFunction.getFunctionToString(this.sqlDialect, this.version);
                String columnAlias = StringUtils.isEmpty(columnQuery.getAlias()) ? "" : this.syntaxAs() + columnQuery.getAlias();
                this.sqlBuilder.append(functionToString).append((CharSequence)arithmeticSql);
                Consumer<Over> overConsumer = functionColumn.getOver();
                if (overConsumer != null) {
                    Over over = new Over();
                    overConsumer.accept(over);
                    String parseOrderBy = this.parseOrderBy(over.getOrderByList());
                    over.setOverClause(parseOrderBy);
                    this.sqlBuilder.append(" ").append(over.toOverString(this.sqlDialect));
                }
                this.sqlBuilder.append(this.syntaxColumnAlias(columnAlias));
                if (columFunction instanceof ColumnModifiers) {
                    ColumnModifiers columnModifiers = (ColumnModifiers)((Object)columFunction);
                    if (columnModifiers.shouldAppendDelimiter()) {
                        this.sqlBuilder.append(columnSeparator);
                    } else {
                        this.sqlBuilder.append(" ");
                    }
                } else {
                    this.sqlBuilder.append(columnSeparator);
                }
                this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
                this.parameterBinder.addParameterBinder(arithmeticParameterBinder);
            }
            if (!(columnQuery instanceof NestedColumn)) continue;
            NestedColumn nestedColumn = (NestedColumn)columnQuery;
            Consumer<AbstractColumnReference> nestedColumnReference = nestedColumn.getNestedColumnReference();
            SqlStatementSelectWrapper sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedColumnReference);
            String columnAliasString = this.syntaxAs() + this.syntaxColumnAlias(columnQuery.getAlias());
            this.sqlBuilder.append("(").append((CharSequence)sqlStatementWrapper.getRawSql()).append(")").append(columnAliasString).append(columnSeparator);
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
        }
    }

    protected String automaticallySelectAliases(JoinTable joinTable) {
        Class<?> tableClass = joinTable.getTableClass();
        TableMeta tableMeta = TableProvider.getTableMeta(tableClass);
        String alias = StringUtils.isEmpty(joinTable.getTableAlias()) ? tableMeta.getTableAlias() : joinTable.getTableAlias();
        String tableAlias = SqlUtils.quoteIdentifier(this.sqlDialect, alias);
        return this.getSchemaName(tableMeta).concat(this.syntaxAs()).concat(tableAlias);
    }

    @Override
    protected boolean parseFormTables() {
        List<JoinTable> joinTables = this.selectSpecification.getJoinTables();
        for (JoinTable joinTable : joinTables) {
            this.parseJoinTable(joinTable);
        }
        return true;
    }

    protected void parseJoinTable(JoinTable joinTable) {
        if (joinTable instanceof FromNestedJoin) {
            FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
            NestedJoin nestedJoin = fromNestedJoin.getNestedJoin();
            SqlStatementSelectWrapper sqlStatementWrapper = this.parseNestedJoinSqlStatementWrapper(nestedJoin);
            this.sqlBuilder.append(" (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(") ").append(this.syntaxAs()).append(nestedJoin.getTableAlias());
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
            return;
        }
        if (joinTable instanceof FromJoin) {
            this.sqlBuilder.append(this.automaticallySelectAliases(joinTable));
            return;
        }
        String syntaxJoin = " " + SqlUtils.getSyntaxJoin(this.sqlDialect, joinTable.getJoinTableType()) + " ";
        if (joinTable instanceof NestedJoin) {
            NestedJoin nestedJoin = (NestedJoin)joinTable;
            SqlStatementSelectWrapper sqlStatementWrapper = this.parseNestedJoinSqlStatementWrapper(nestedJoin);
            this.sqlBuilder.append(" ").append(syntaxJoin).append(" (").append((CharSequence)sqlStatementWrapper.getRawSql()).append(") ").append(this.syntaxAs()).append(nestedJoin.getTableAlias());
            this.parameterBinder.addParameterBinder(sqlStatementWrapper.getParameterBinder());
            this.appendOnCondition(joinTable);
            return;
        }
        if (joinTable instanceof TableFunctionJoin) {
            TableFunctionJoin tableFunctionJoin = (TableFunctionJoin)joinTable;
            TableFunction tableFunction = tableFunctionJoin.getTableFunction().get();
            String functionToString = tableFunction.getFunctionToString(this.sqlDialect, this.version);
            this.sqlBuilder.append(" ").append(syntaxJoin).append(functionToString).append(this.syntaxAs()).append(tableFunctionJoin.getTableAlias());
            this.parameterBinder.addParameterBinder(tableFunction.getParameterBinder());
            this.appendOnCondition(joinTable);
            return;
        }
        this.sqlBuilder.append(syntaxJoin).append(this.automaticallySelectAliases(joinTable));
        this.appendOnCondition(joinTable);
    }

    private void appendOnCondition(JoinTable joinTable) {
        Consumer<Condition> onCondition = joinTable.getOnCondition();
        if (onCondition != null) {
            String syntaxOn = " " + SqlUtils.getSyntaxOn(this.sqlDialect) + " ";
            Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
            onCondition.accept((Condition)whereCondition);
            this.parameterBinder.addParameterBinder(((GenericWhereCondition)whereCondition).getParameterBinder());
            this.sqlBuilder.append(syntaxOn).append(((GenericWhereCondition)whereCondition).getWhereConditionSyntax());
        }
    }

    private SqlStatementSelectWrapper parseNestedJoinSqlStatementWrapper(NestedJoin nestedJoin) {
        SqlStatementSelectWrapper sqlStatementWrapper = nestedJoin.getSqlStatementWrapper();
        if (sqlStatementWrapper == null) {
            sqlStatementWrapper = SqlUtils.executeNestedSelect(nestedJoin.getNestedSelect());
        }
        return sqlStatementWrapper;
    }

    @Override
    public void parseLimit() {
        LimitInfo limitInfo = this.selectSpecification.getLimitInfo();
        if (limitInfo == null) {
            return;
        }
        this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxLimit(SqlDialect.MYSQL)).append(" ");
        if (limitInfo.getOffset() != null) {
            this.sqlBuilder.append(SqlUtils.registerValueWithKey(this.parameterBinder, limitInfo.getOffset())).append(", ");
        }
        this.sqlBuilder.append(SqlUtils.registerValueWithKey(this.parameterBinder, limitInfo.getLimit()));
    }

    private void parseAllColumn(AllColumn allColumn) {
        String tableAlias = allColumn.getTableAlias();
        if (StringUtils.isNotEmpty(tableAlias)) {
            String[] clazz = new String[1];
            String finalTableAlias = tableAlias;
            this.aliasTableMap.forEach((cls, alias) -> {
                if (alias == null) {
                    return;
                }
                if (alias.equals(finalTableAlias)) {
                    clazz[0] = cls;
                }
            });
            if (clazz[0] == null) {
                throw new IllegalArgumentException("Table alias does not exist: " + tableAlias);
            }
            if (clazz[0].equals(tableAlias)) {
                this.sqlBuilder.append(tableAlias).append(".*");
                return;
            }
            List<ColumnMeta> columnMetas = TableProvider.getTableMeta(clazz[0]).getColumnMetas();
            this.appendQueryColumn(columnMetas, tableAlias);
            return;
        }
        Class<?> tableClass = allColumn.getTableClass();
        if (tableClass != null) {
            this.appendQueryAllColumnForClass(tableClass);
            return;
        }
        AtomicInteger cursor = new AtomicInteger();
        this.aliasTableMap.forEach((cls, alias) -> {
            if (cursor.getAndIncrement() != 0) {
                this.sqlBuilder.append(", ");
            }
            this.appendQueryAllColumnForClass((String)cls);
        });
    }

    private void appendQueryAllColumnForClass(Class<?> tableClass) {
        this.appendQueryAllColumnForClass(tableClass.getCanonicalName());
    }

    private void appendQueryAllColumnForClass(String canonicalName) {
        TableMeta tableMeta;
        try {
            tableMeta = TableProvider.getTableMeta(canonicalName);
        }
        catch (RuntimeException e) {
            tableMeta = null;
        }
        if (tableMeta == null) {
            this.sqlBuilder.append(canonicalName).append(".*");
            return;
        }
        String tableAlias = (String)this.aliasTableMap.get(canonicalName);
        tableAlias = tableAlias == null ? tableMeta.getTableAlias() : tableAlias;
        List<ColumnMeta> columnMetas = tableMeta.getColumnMetas();
        this.appendQueryColumn(columnMetas, tableAlias);
    }

    private void appendQueryColumn(List<ColumnMeta> columnMetas, String tableAlias) {
        for (int i = 0; i < columnMetas.size(); ++i) {
            ColumnMeta columnMeta = columnMetas.get(i);
            this.sqlBuilder.append(SqlUtils.quoteIdentifier(this.sqlDialect, tableAlias)).append(".").append(SqlUtils.quoteIdentifier(this.sqlDialect, columnMeta.getColumnName())).append(" ").append(SqlUtils.getSyntaxAs(this.sqlDialect)).append(" ").append(this.syntaxColumnAlias(columnMeta.getField().getName()));
            if (columnMetas.size() - 1 <= i) continue;
            this.sqlBuilder.append(", ");
        }
    }
}

