/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.dml.select.build;

import com.dynamic.sql.context.SchemaContextHolder;
import com.dynamic.sql.context.properties.SchemaProperties;
import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.condition.WhereCondition;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.core.dml.select.HavingCondition;
import com.dynamic.sql.core.dml.select.build.SelectSpecification;
import com.dynamic.sql.core.dml.select.build.SqlStatementSelectWrapper;
import com.dynamic.sql.core.dml.select.build.join.FromNestedJoin;
import com.dynamic.sql.core.dml.select.build.join.JoinTable;
import com.dynamic.sql.core.dml.select.build.join.NestedJoin;
import com.dynamic.sql.core.dml.select.build.join.TableFunctionJoin;
import com.dynamic.sql.core.dml.select.order.OrderBy;
import com.dynamic.sql.core.placeholder.ParameterBinder;
import com.dynamic.sql.datasource.DataSourceMeta;
import com.dynamic.sql.datasource.DataSourceProvider;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.table.TableMeta;
import com.dynamic.sql.table.TableProvider;
import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.SqlUtils;
import com.dynamic.sql.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class SqlSelectBuilder {
    protected final StringBuilder sqlBuilder = new StringBuilder();
    protected final SelectSpecification selectSpecification;
    protected final Version version;
    protected final SqlDialect sqlDialect;
    protected final String dataSourceName;
    protected final ParameterBinder parameterBinder = new ParameterBinder();
    protected final Map<String, String> aliasTableMap = new HashMap<String, String>();

    protected SqlSelectBuilder(SelectSpecification selectSpecification) {
        SchemaProperties schemaProperties;
        this.selectSpecification = selectSpecification;
        JoinTable joinTable = selectSpecification.getJoinTables().get(0);
        if (joinTable instanceof FromNestedJoin) {
            FromNestedJoin fromNestedJoin = (FromNestedJoin)joinTable;
            SqlStatementSelectWrapper sqlStatementWrapper = fromNestedJoin.getNestedJoin().getSqlStatementWrapper();
            String dataSourceName1 = sqlStatementWrapper.getDataSourceName();
            schemaProperties = SchemaContextHolder.getSchemaProperties(dataSourceName1);
        } else {
            Class<?> tableClass = joinTable.getTableClass();
            TableMeta tableMeta = TableProvider.getTableMeta(tableClass);
            schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        }
        this.version = this.getVersion(schemaProperties);
        this.sqlDialect = schemaProperties.getSqlDialect();
        this.dataSourceName = schemaProperties.getDataSourceName();
    }

    protected abstract void parseColumnFunction();

    protected abstract boolean parseFormTables();

    protected abstract void parseLimit();

    public final SqlStatementSelectWrapper build() {
        List<JoinTable> joinTables = this.selectSpecification.getJoinTables();
        joinTables.forEach(joinTable -> {
            String key = joinTable instanceof FromNestedJoin || joinTable instanceof NestedJoin || joinTable instanceof TableFunctionJoin ? joinTable.getTableAlias() : joinTable.getTableClass().getCanonicalName();
            String alias = this.aliasTableMap.get(key);
            if (alias != null && joinTable.getTableAlias() == null) {
                throw new IllegalStateException("Repeatedly associated with the same table: " + key + ", When querying the same table continuously at the current level, aliases should be used to distinguish them");
            }
            if (alias == null) {
                this.aliasTableMap.put(key, joinTable.getTableAlias());
            }
        });
        this.parseColumnFunction();
        this.sqlBuilder.append(" ");
        this.sqlBuilder.append(SqlUtils.getSyntaxFrom(this.sqlDialect)).append(" ");
        if (this.parseFormTables()) {
            this.continueParsingSql();
        }
        JoinTable guessTheTarget = joinTables.stream().filter(joinTable -> joinTable.getTableClass() != null).findFirst().orElse(null);
        Class<?> guessTheTargetClass = null;
        if (guessTheTarget != null) {
            guessTheTargetClass = guessTheTarget.getTableClass();
        }
        return new SqlStatementSelectWrapper(this.dataSourceName, this.sqlBuilder, this.parameterBinder, guessTheTargetClass);
    }

    protected void continueParsingSql() {
        if (this.selectSpecification.getWhereCondition() != null) {
            this.parseWhere(this.selectSpecification.getWhereCondition());
        }
        if (CollectionUtils.isNotEmpty(this.selectSpecification.getGroupByFields())) {
            this.parseGroupBy(this.selectSpecification.getGroupByFields());
        }
        if (this.selectSpecification.getHavingCondition() != null) {
            this.parseHaving(this.selectSpecification.getHavingCondition());
        }
        if (CollectionUtils.isNotEmpty(this.selectSpecification.getOrderBys())) {
            this.sqlBuilder.append(this.parseOrderBy(this.selectSpecification.getOrderBys()));
        }
        if (this.selectSpecification.getLimitInfo() != null) {
            this.parseLimit();
        }
    }

    private void parseGroupBy(List<Fn<?, ?>> groupByFields) {
        this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxGroupBy(this.sqlDialect));
        for (Fn<?, ?> groupByField : groupByFields) {
            this.sqlBuilder.append(" ").append(SqlUtils.extractQualifiedAlias(groupByField, this.aliasTableMap, this.dataSourceName));
        }
    }

    private void parseHaving(Consumer<HavingCondition> havingCondition) {
        Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
        havingCondition.accept((HavingCondition)whereCondition);
        this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxHaving(this.sqlDialect)).append(" ").append(((GenericWhereCondition)whereCondition).getWhereConditionSyntax());
        ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
        this.parameterBinder.addParameterBinder(whereParameterBinder);
    }

    protected String parseOrderBy(List<OrderBy> orderBys) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ").append(SqlUtils.getSyntaxOrderBy(this.sqlDialect));
        for (int i = 0; i < orderBys.size(); ++i) {
            OrderBy orderBy = orderBys.get(i);
            String columnSeparator = "";
            if (orderBys.size() - 1 != i) {
                columnSeparator = ",";
            }
            stringBuilder.append(SqlUtils.extractQualifiedAliasOrderBy(orderBy, this.aliasTableMap, this.dataSourceName)).append(" ").append(orderBy.getSortOrder().toSqlString(this.sqlDialect)).append(columnSeparator);
        }
        return stringBuilder.toString();
    }

    private void parseWhere(Consumer<WhereCondition> whereConditionConsumer) {
        Object whereCondition = SqlUtils.matchDialectCondition(this.sqlDialect, this.version, this.aliasTableMap, this.dataSourceName);
        whereConditionConsumer.accept((WhereCondition)whereCondition);
        String whereConditionSyntax = ((GenericWhereCondition)whereCondition).getWhereConditionSyntax();
        if (StringUtils.isNotEmpty(whereConditionSyntax) && !whereConditionSyntax.trim().startsWith("limit")) {
            this.sqlBuilder.append(" ").append(SqlUtils.getSyntaxWhere(this.sqlDialect));
        }
        this.sqlBuilder.append(" ").append(whereConditionSyntax);
        ParameterBinder whereParameterBinder = ((GenericWhereCondition)whereCondition).getParameterBinder();
        this.parameterBinder.addParameterBinder(whereParameterBinder);
    }

    private Version getVersion(SchemaProperties schemaProperties) {
        return new Version(schemaProperties.getMajorVersionNumber(), schemaProperties.getMinorVersionNumber(), schemaProperties.getPatchVersionNumber());
    }

    protected String getSchemaName(TableMeta tableMeta) {
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(tableMeta.getBindDataSourceName());
        if (schemaProperties.isUseSchemaInQuery()) {
            DataSourceMeta dataSourceMeta = DataSourceProvider.getDataSourceMeta(tableMeta.getBindDataSourceName());
            return SqlUtils.quoteIdentifier(this.sqlDialect, dataSourceMeta.getSchema()) + "." + SqlUtils.quoteIdentifier(this.sqlDialect, tableMeta.getTableName());
        }
        return SqlUtils.quoteIdentifier(this.sqlDialect, tableMeta.getTableName());
    }

    protected String syntaxAs() {
        SchemaProperties schemaProperties = SchemaContextHolder.getSchemaProperties(this.dataSourceName);
        return schemaProperties.isUseAsInQuery() ? " " + SqlUtils.getSyntaxAs(this.sqlDialect) + " " : " ";
    }

    protected String syntaxColumnAlias(String columnAlias) {
        if (this.sqlDialect == SqlDialect.ORACLE) {
            return "\"" + columnAlias + "\"";
        }
        return columnAlias;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

